/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar.webview.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.ValueCallback;
import android.widget.FrameLayout;
import org.json.JSONException;
import org.json.JSONObject;
import tv.athena.live.api.activitybar.bean.ActivityBarConfig;
import tv.athena.live.api.activitybar.bean.EntryData;
import tv.athena.live.api.activitybar.service.IJsApiModule;
import tv.athena.live.api.activitybar.service.IJsSupportWebApi;
import tv.athena.live.api.activitybar.service.IWebViewUIClient;
import tv.athena.live.component.business.activitybar.webview.fragment.WebViewFragment;
import tv.athena.live.component.business.activitybar.webview.util.HttpsParser;
import tv.athena.live.utils.ALog;
import tv.athena.live.utils.UIUtils;
import tv.athena.util.FP;

public class WebViewDialogFragment
extends DialogFragment
implements IJsSupportWebApi {
    private static final String TAG = "WebViewDialogFragment";
    private WebViewFragment mWebViewFragment;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private IWebViewUIClient mIWebViewUIClient;
    protected String mPageDefBackStyle;
    private long mOwnerUid;
    private long mSid;
    private String mOwnerName;
    private DialogBuilder mDialogBuilder;
    private Activity activity;
    private ActivityBarConfig config;
    private int mStyle = -2;
    private int mHeight = -1;
    private int mWidth = -1;
    private String mGravity;
    private boolean isFullScreen = false;
    private boolean isShowTitle = false;
    private View.OnClickListener dismissLisnener = view -> {
        ALog.i((String)TAG, (String)"finishActivityListener clicked");
        if (!this.onBackPressedHandler()) {
            this.dismissAllowingStateLoss();
        }
    };

    public static WebViewDialogFragment newInstance(String url, int feature, String configJson) {
        WebViewDialogFragment fragment = new WebViewDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("url", HttpsParser.convertToHttps(url));
        bundle.putInt("feature", feature);
        bundle.putString("configUI", configJson);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void setActivityBarConfig(ActivityBarConfig config) {
        this.config = config;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.setIJsSupportWebApi(this);
            this.mWebViewFragment.onCreate(savedInstanceState);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (this.mDialogBuilder != null) {
            return this.mDialogBuilder.onCreateDialog();
        }
        int gravity = 80;
        if (!TextUtils.isEmpty((CharSequence)this.mGravity)) {
            switch (this.mGravity) {
                case "TOP": {
                    gravity = 48;
                    break;
                }
                case "CENTER": {
                    gravity = 17;
                    break;
                }
                default: {
                    gravity = 80;
                }
            }
        }
        Dialog dialog = new Dialog((Context)this.getActivity()){

            public void onBackPressed() {
                ALog.i((String)WebViewDialogFragment.TAG, (String)"onBackPressed");
                if (!WebViewDialogFragment.this.onBackPressedHandler()) {
                    super.onBackPressed();
                }
            }
        };
        dialog.requestWindowFeature(1);
        dialog.setCanceledOnTouchOutside(true);
        Window window = dialog.getWindow();
        window.setDimAmount(0.2f);
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.gravity = gravity;
        lp.width = -1;
        window.setAttributes(lp);
        return dialog;
    }

    public void setWebViewUIClient(IWebViewUIClient client) {
        this.mIWebViewUIClient = client;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = this.mWebViewFragment.onCreateView(inflater, container, savedInstanceState);
        this.addTitle();
        return view;
    }

    private void addTitle() {
        FrameLayout fl = this.mWebViewFragment.getTitleContainer();
        if (fl == null) {
            return;
        }
        if (this.isShowTitle) {
            if (this.config != null && this.config.getIConfigNavigation() != null) {
                View back;
                View titleView = this.config.getIConfigNavigation().getTitleView();
                if (titleView != null) {
                    FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
                    fl.addView(titleView, (ViewGroup.LayoutParams)lp);
                    fl.setVisibility(0);
                }
                if ((back = this.config.getIConfigNavigation().getBackView()) != null && !back.hasOnClickListeners()) {
                    back.setOnClickListener(this.dismissLisnener);
                }
            }
        } else {
            fl.setVisibility(8);
        }
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        this.mWebViewFragment.onViewCreated(view, savedInstanceState);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.onDestroy();
        }
    }

    public void onStop() {
        super.onStop();
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.onStop();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.onPause();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.onConfigurationChanged(newConfig);
        }
    }

    public void onResume() {
        super.onResume();
        ViewGroup.LayoutParams layoutParams = this.getView().getLayoutParams();
        layoutParams.height = this.mHeight;
        layoutParams.width = this.mWidth;
        this.getView().setLayoutParams(layoutParams);
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.onResume();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.onDestroyView();
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.onActivityCreated(savedInstanceState);
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.activity = this.getActivity();
        if (this.mWebViewFragment == null) {
            Bundle bundle = this.getArguments();
            String url = "";
            int feature = 0;
            if (bundle != null) {
                url = bundle.getString("url", "");
                feature = bundle.getInt("feature");
                String configUIJson = bundle.getString("configUI", "");
                this.readConfig(configUIJson);
            }
            this.mWebViewFragment = WebViewFragment.newInstance((Context)this.getActivity(), url, feature);
            this.mWebViewFragment.setActivityBarConfig(this.config);
            this.mWebViewFragment.onAttach(context);
            this.mWebViewFragment.setWebViewUIClient(this.mIWebViewUIClient);
        }
    }

    private void readConfig(String configUIJson) {
        if (TextUtils.isEmpty((CharSequence)configUIJson)) {
            return;
        }
        try {
            JSONObject object = new JSONObject(configUIJson);
            this.isFullScreen = object.optBoolean("isFullScreen", false);
            this.isShowTitle = object.optBoolean("isShowTitle", false);
            int width = object.optInt("width", -2);
            int screenWidth = UIUtils.getScreenWidth((Context)this.activity);
            this.mWidth = width <= -2 || width > screenWidth ? -1 : width;
            int height = object.optInt("height", -2);
            int screenHeight = UIUtils.getScreenHeight((Context)this.activity);
            this.mHeight = this.isFullScreen ? -1 : (height <= -2 || height > screenHeight ? screenHeight / 2 : height);
            this.mStyle = object.optInt("style");
            this.mGravity = object.optString("gravity");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void onDetach() {
        super.onDetach();
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.setIJsSupportWebApi(null);
            this.mWebViewFragment.onDetach();
            this.mWebViewFragment.setWebViewUIClient(null);
            this.mWebViewFragment = null;
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(context, attrs, savedInstanceState);
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.onInflate(context, attrs, savedInstanceState);
        }
    }

    public void onStart() {
        super.onStart();
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.onStart();
        }
    }

    public void setOwnerUid(long ownerUid) {
        this.mOwnerUid = ownerUid;
    }

    public void setSid(long sid) {
        this.mSid = sid;
    }

    public void setOwnerName(String ownerName) {
        this.mOwnerName = ownerName;
    }

    private boolean onBackPressedHandler() {
        boolean isHandler = false;
        ALog.i((String)TAG, (String)("\u7ad9\u70b9\u9ed8\u8ba4\u56de\u9000\u65b9\u5f0f  mPageDefBackStyle:" + this.mPageDefBackStyle));
        if (FP.empty((CharSequence)this.mPageDefBackStyle)) {
            this.mPageDefBackStyle = "history";
        }
        if (this.mPageDefBackStyle != null && this.mPageDefBackStyle.equals("history") && this.mWebViewFragment != null && this.mWebViewFragment.getWebView().canGoBack()) {
            isHandler = true;
            this.mWebViewFragment.getWebView().goBack();
        }
        return isHandler;
    }

    public long getOwnerUid() {
        return this.mOwnerUid;
    }

    public long getSid() {
        return this.mSid;
    }

    public String getOwnerName() {
        return this.mOwnerName;
    }

    public void showProgressDialog(String label, boolean cancelable, int timeout) {
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.showLoading();
        }
    }

    public void hideProgressDialog() {
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.hideLoading();
        }
    }

    public void loadJavascript(String json) {
        if (this.mWebViewFragment != null) {
            this.mWebViewFragment.loadJavaScript(json, new ValueCallback<String>(){

                public void onReceiveValue(String value) {
                    ALog.d((String)WebViewDialogFragment.TAG, (String)("onReceiveValue: " + value));
                }
            });
        }
    }

    public void showPopupWebView(String url, String configUIJson) {
    }

    public void closePopupWebView() {
        this.dismissAllowingStateLoss();
    }

    public EntryData getEntryData() {
        return null;
    }

    public void configNavigation(String param, IJsApiModule.IJSCallback callback) {
        if (this.config != null && this.config.getIConfigNavigation() != null) {
            this.config.getIConfigNavigation().configNavigation(param, callback);
        }
    }

    public String getBroadcastData() {
        return null;
    }

    public static interface DialogBuilder {
        public Dialog onCreateDialog();
    }
}

