/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.text.TextUtils;
import com.yy.liveplatform.proto.nano.LpfActivity;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.core.sly.Sly;
import tv.athena.core.sly.SlyMessage;
import tv.athena.live.api.activitybar.ActivityBarApi;
import tv.athena.live.api.activitybar.bean.ActivityBarConfig;
import tv.athena.live.api.activitybar.bean.BroadcastData;
import tv.athena.live.api.activitybar.bean.EntryData;
import tv.athena.live.base.arch.IComponentApi;
import tv.athena.live.base.manager.CommonViewModel;
import tv.athena.live.base.manager.ComponentContext;
import tv.athena.live.component.business.activitybar.ActivityBarView;
import tv.athena.live.component.business.activitybar.repository.ActivityBarServiceImpl;
import tv.athena.live.component.business.activitybar.repository.IActivityBarService;
import tv.athena.live.utils.ALog;
import tv.athena.live.utils.ThreadSafeMutableLiveData;
import tv.athena.service.api.IMessageCallback;
import tv.athena.service.api.MessageResponse;
import tv.athena.service.api.ServiceFailResult;

class ActivityBarApiImpl
implements ActivityBarApi {
    private static final String TAG = "ActivityBarApiImpl";
    private ActivityBarView activityBarView;
    private IActivityBarService repository = new ActivityBarServiceImpl();
    private String mEntryUrl;
    private ComponentContext context;
    private MutableLiveData<Boolean> mEntryShow = new ThreadSafeMutableLiveData();
    private MutableLiveData<BroadcastData> mBroadcastData = new ThreadSafeMutableLiveData();
    private EntryData data;
    private BroadcastData broadcastData;
    private List<Observer<BroadcastData>> observers = new ArrayList<Observer<BroadcastData>>();

    ActivityBarApiImpl() {
    }

    public Class<? extends IComponentApi> getApiKey() {
        return ActivityBarApi.class;
    }

    private void observeId(ActivityBarConfig config) {
        if (config != null && this.activityBarView != null) {
            this.activityBarView.setId(config.getId());
        }
    }

    public void show(final ActivityBarConfig config) {
        this.observeId(config);
        if (this.activityBarView != null && this.activityBarView.isReady()) {
            this.repository.queryActWindow(this.context.getCommonViewModel().getSid(), false, new IMessageCallback<LpfActivity.IfActivityWindowPresentResp>(){

                public void onMessageSuccess(@NotNull MessageResponse<LpfActivity.IfActivityWindowPresentResp> messageResponse) {
                    try {
                        LpfActivity.IfActivityWindowPresentResp message = (LpfActivity.IfActivityWindowPresentResp)messageResponse.getMessage();
                        ALog.e((String)ActivityBarApiImpl.TAG, (String)message.toString());
                        ActivityBarApiImpl.this.mEntryUrl = message.showUrl;
                        if (ActivityBarApiImpl.this.data == null) {
                            ActivityBarApiImpl.this.data = new EntryData();
                        }
                        ActivityBarApiImpl.this.data.setShowUrl(ActivityBarApiImpl.this.mEntryUrl);
                        ActivityBarApiImpl.this.data.setActivityInfos(message.activityInfos);
                        ActivityBarApiImpl.this.data.setIfPresent(message.ifPresent);
                        ActivityBarApiImpl.this.mEntryShow.setValue((Object)message.ifPresent);
                        String url = ActivityBarApiImpl.this.getEntryUrl();
                        if (message.code == 0 && url != null) {
                            ActivityBarApiImpl.this.activityBarView.showActivity(config, url, ActivityBarApiImpl.this.data);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onMessageFail(@NotNull ServiceFailResult serviceFailResult, @Nullable Exception e) {
                    ActivityBarApiImpl.this.data = null;
                }

                @NotNull
                public LpfActivity.IfActivityWindowPresentResp get() {
                    return new LpfActivity.IfActivityWindowPresentResp();
                }
            });
        }
    }

    public EntryData getEntryData() {
        return this.data;
    }

    public String getEntryUrl() {
        try {
            String url = this.mEntryUrl;
            CommonViewModel commonData = this.context.getCommonViewModel();
            if (!TextUtils.isEmpty((CharSequence)url)) {
                String tempUrl = "sid=" + commonData.getSid() + "&ownerId=" + commonData.getRoomOwnerUid() + "&isLivingAnchor=0&userId=" + commonData.getMyUid();
                if (url.contains("?")) {
                    return url + "&" + tempUrl;
                }
                return url + "?" + tempUrl;
            }
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void showPopView(String url, String configUIJson) {
        if (this.activityBarView != null) {
            this.activityBarView.showPopView(url, configUIJson);
        }
    }

    public void closePopView() {
        if (this.activityBarView != null) {
            this.activityBarView.closePopView();
        }
    }

    public void observeBroadcastData(LifecycleOwner owner, Observer<BroadcastData> observer) {
        this.observers.add(observer);
        this.mBroadcastData.observe(owner, observer);
    }

    public void removeObserver(Observer<BroadcastData> observer) {
        this.observers.remove(observer);
        this.mBroadcastData.removeObserver(observer);
    }

    public void clearObserver() {
        if (this.observers != null && this.observers.size() > 0) {
            for (Observer<BroadcastData> obs : this.observers) {
                this.mBroadcastData.removeObserver(obs);
            }
            this.observers.clear();
        }
    }

    public void loadJavascript(String js) {
        if (this.activityBarView != null) {
            this.activityBarView.loadJavaScript(js);
        }
    }

    public void bindActivityBarView(ActivityBarView activityBarView) {
        this.activityBarView = activityBarView;
    }

    public void saveBroadcastData(String url, String data) {
        if (TextUtils.isEmpty((CharSequence)data)) {
            return;
        }
        if (this.broadcastData == null) {
            this.broadcastData = new BroadcastData();
        }
        this.broadcastData.setUrl(url);
        this.broadcastData.setData(data);
        Sly.Companion.postMessage((SlyMessage)this.broadcastData);
        this.mBroadcastData.setValue((Object)this.broadcastData);
    }

    public void setContext(ComponentContext mComponentContext) {
        this.context = mComponentContext;
    }
}

