/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.utils;

import android.util.Log;
import tv.athena.live.api.ILogDelegate;

public final class NLog {
    private static final String aLogAthNative = "AthNative ";
    private static ILogDelegate mLogDelegate;

    public static void setLogeDelegate(ILogDelegate logeDelegate) {
        mLogDelegate = logeDelegate;
    }

    public static ILogDelegate getLogeDelegate() {
        return mLogDelegate;
    }

    public static void v(String tag, String format, Object ... args) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.v(aLogAthNative + tag, format, args);
        } else {
            Log.v((String)(aLogAthNative + tag), (String)String.format(format, args));
        }
    }

    public static void v(String tag, String msg) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.v(aLogAthNative + tag, msg);
        } else {
            Log.v((String)(aLogAthNative + tag), (String)msg);
        }
    }

    public static void d(String tag, String format, Object ... args) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.d(aLogAthNative + tag, format, args);
        } else {
            Log.d((String)(aLogAthNative + tag), (String)String.format(format, args));
        }
    }

    public static void d(String tag, String msg) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.e(aLogAthNative + tag, msg, new Object[0]);
        } else {
            Log.d((String)(aLogAthNative + tag), (String)msg);
        }
    }

    public static void d(String tag, String msg, Throwable t) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.d(aLogAthNative + tag, msg, t);
        } else {
            Log.d((String)(aLogAthNative + tag), (String)msg, (Throwable)t);
        }
    }

    public static void i(String tag, String format, Object ... args) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.i(aLogAthNative + tag, format, args);
        } else {
            Log.i((String)(aLogAthNative + tag), (String)String.format(format, args));
        }
    }

    public static void i(String tag, String msg) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.i(aLogAthNative + tag, msg);
        } else {
            Log.i((String)(aLogAthNative + tag), (String)msg);
        }
    }

    public static void w(String tag, String format, Object ... args) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.w(aLogAthNative + tag + " @warn", format, args);
        } else {
            Log.w((String)(aLogAthNative + tag + " @warn"), (String)String.format(format, args));
        }
    }

    public static void w(String tag, String msg) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.w(aLogAthNative + tag + " @warn", msg);
        } else {
            Log.w((String)(aLogAthNative + tag + " @warn"), (String)msg);
        }
    }

    public static void e(String tag, String format, Object ... args) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.e(aLogAthNative + tag + " @error", format, args);
        } else {
            Log.e((String)(aLogAthNative + tag + " @error"), (String)String.format(format, args));
        }
    }

    public static void e(String tag, String msg, Throwable t) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.e(aLogAthNative + tag + " @error", msg, t);
        } else {
            Log.e((String)(aLogAthNative + tag + " @error"), (String)msg, (Throwable)t);
        }
    }

    public static void thunderLog(String tag, String format, Object ... args) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.v(tag, format, args);
        } else {
            Log.v((String)tag, (String)String.format(format, args));
        }
    }

    public static void blitzPlayerLog(String tag, String format, Object ... args) {
        if (NLog.getLogeDelegate() != null) {
            mLogDelegate.v(tag, format, args);
        } else {
            Log.v((String)tag, (String)String.format(format, args));
        }
    }
}

