/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.common;

import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tv.athena.live.common.BaseConfig;
import tv.athena.live.common.IConfigConsumer;
import tv.athena.live.utils.ALog;

public class ConfigConsumerSupplier {
    private static ConfigConsumerSupplier sInstance;
    private HashMap<Class<? extends IConfigConsumer>, IConfigConsumer> mConsumerMap = new HashMap();
    private Map<String, String> mAllServerConfigs = new HashMap<String, String>();

    private ConfigConsumerSupplier() {
    }

    public static ConfigConsumerSupplier getInstance() {
        if (sInstance == null) {
            sInstance = new ConfigConsumerSupplier();
        }
        return sInstance;
    }

    public void initConfigConsumer(List<BaseConfig> configList) {
        for (BaseConfig config : configList) {
            Class<? extends IConfigConsumer<? extends BaseConfig>> api = config.getConsumerImplCls();
            if (!this.mConsumerMap.containsKey(api)) {
                IConfigConsumer consumer = this.newConsumerInstance(api);
                if (consumer == null) {
                    ALog.w("ConfigConsumerSupplier", "initConfigConsumer: newConsumerInstance null: " + config.getConsumerImplCls());
                    continue;
                }
                this.mConsumerMap.put(api, consumer);
                consumer.onInit(config);
                continue;
            }
            IConfigConsumer existConsumer = this.mConsumerMap.get(api);
            ALog.w("ConfigConsumerSupplier", "initConfigConsumer: Duplicate init consumer:" + existConsumer);
            if (existConsumer == null) continue;
            existConsumer.onInit(config);
        }
    }

    public ArrayList<String> getExpectServerConfigurationKeys(List<BaseConfig> configList) {
        ArrayList<String> requestKeys = new ArrayList<String>();
        for (BaseConfig config : configList) {
            IConfigConsumer consumer;
            Class<? extends IConfigConsumer<? extends BaseConfig>> api = config.getConsumerImplCls();
            if (api == null || (consumer = this.mConsumerMap.get(api)) == null) continue;
            requestKeys.addAll(consumer.expectServerConfigurationKeys());
        }
        return requestKeys;
    }

    public void dispatcherServerConfig(Map<String, String> allConfigs) {
        this.mAllServerConfigs.clear();
        this.mAllServerConfigs.putAll(allConfigs);
        for (Map.Entry<Class<? extends IConfigConsumer>, IConfigConsumer> entry : this.mConsumerMap.entrySet()) {
            HashMap<String, String> expectConfigs = new HashMap<String, String>();
            IConfigConsumer consumer = entry.getValue();
            List<String> expectServerConfigurationKeys = consumer.expectServerConfigurationKeys();
            for (String expectKey : expectServerConfigurationKeys) {
                expectConfigs.put(expectKey, allConfigs.get(expectKey));
            }
            consumer.onConfigFromServer(expectConfigs);
        }
    }

    public <T extends IConfigConsumer> T getConfigConsumer(Class<T> clz) {
        return (T)this.mConsumerMap.get(clz);
    }

    private IConfigConsumer newConsumerInstance(Class<? extends IConfigConsumer> clazz) {
        try {
            if (clazz != null) {
                return clazz.newInstance();
            }
            return null;
        }
        catch (Exception e) {
            ALog.e("ConfigConsumerSupplier", "newConsumerInstance: " + Log.getStackTraceString((Throwable)e), new Object[0]);
            return null;
        }
    }

    private Class<? extends IConfigConsumer> createClassFromName(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            ALog.e("ConfigConsumerSupplier", "createClassFromName: " + Log.getStackTraceString((Throwable)e), new Object[0]);
            return null;
        }
    }
}

