/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.klog.hide.writer;

import android.os.Looper;
import android.os.Process;
import android.util.Log;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.klog.api.IKLogFlush;
import tv.athena.klog.api.LogLevel;
import tv.athena.klog.hide.util.BundleMessage;
import tv.athena.klog.hide.writer.WriteLogThread;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001f\u001a\u00020 J6\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\nJS\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\n2\u0016\u0010)\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010*\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010+J6\u0010,\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\nJS\u0010,\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\n2\u0016\u0010)\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010*\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010+J\u0006\u0010-\u001a\u00020 J\u000e\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/J6\u00100\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\nJS\u00100\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\n2\u0016\u0010)\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010*\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010+J\u0006\u00101\u001a\u00020 JP\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\nH\u0002Jm\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\n2\u0016\u0010)\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010*\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u00106J.\u00107\u001a\u00020 2\u0006\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\nJ\u0010\u0010=\u001a\u00020 2\u0006\u0010'\u001a\u00020\u001cH\u0002J\u000e\u0010>\u001a\u00020 2\u0006\u0010?\u001a\u00020\u0004J\u000e\u0010@\u001a\u00020 2\u0006\u0010;\u001a\u00020\u0004J\u000e\u0010A\u001a\u00020 2\u0006\u0010B\u001a\u00020CJ6\u0010D\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\nJS\u0010D\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\n2\u0016\u0010)\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010*\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010+J6\u0010E\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\nJS\u0010E\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\n2\u0016\u0010)\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010*\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Ltv/athena/klog/hide/writer/FileWriter;", "", "()V", "CLOSE", "", "FLUSH", "OPEN", "SET_FILE_MAX_SIZE", "SET_LOG_LEVEL", "THREAD_NAME", "", "USE_CONSOLE_LOG", "WRITE", "condition", "Ljava/util/concurrent/locks/Condition;", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "lock", "Ljava/util/concurrent/locks/Lock;", "getLock", "()Ljava/util/concurrent/locks/Lock;", "mInited", "Ljava/util/concurrent/atomic/AtomicBoolean;", "mMainTid", "", "mProcessId", "mQueue", "Ljava/util/Queue;", "Ltv/athena/klog/hide/util/BundleMessage;", "wThread", "Ltv/athena/klog/hide/writer/WriteLogThread;", "close", "", "d", "tag", "fileName", "funcName", "line", "tid", "msg", "format", "args", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IJLjava/lang/String;[Ljava/lang/Object;)V", "e", "flush", "flushCallback", "Ltv/athena/klog/api/IKLogFlush;", "i", "init", "logWrite", "level", "pid", "maintid", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;IIJJLjava/lang/String;[Ljava/lang/Object;)V", "open", "logDir", "mmapDir", "namePrefix", "logLevel", "publicKey", "postMessage", "setFileMaxSize", "size", "setLogLevel", "useConsoleLog", "use", "", "v", "w", "klog_release"})
public final class FileWriter {
    private static AtomicBoolean mInited;
    private static int mProcessId;
    private static long mMainTid;
    private static Queue<BundleMessage> mQueue;
    private static WriteLogThread wThread;
    public static final int OPEN = 1;
    public static final int FLUSH = 2;
    public static final int CLOSE = 3;
    public static final int SET_LOG_LEVEL = 4;
    public static final int SET_FILE_MAX_SIZE = 5;
    public static final int USE_CONSOLE_LOG = 6;
    public static final int WRITE = 7;
    private static final String THREAD_NAME = "writer_klog";
    @NotNull
    private static final Lock lock;
    @NotNull
    private static final Condition condition;
    public static final FileWriter INSTANCE;

    @NotNull
    public final Lock getLock() {
        return lock;
    }

    @NotNull
    public final Condition getCondition() {
        return condition;
    }

    public final void init() {
        if (!mInited.get()) {
            WriteLogThread writeLogThread = wThread = new WriteLogThread(mQueue);
            if (writeLogThread != null) {
                writeLogThread.start();
            }
            WriteLogThread writeLogThread2 = wThread;
            if (writeLogThread2 != null) {
                writeLogThread2.setPriority(10);
            }
            WriteLogThread writeLogThread3 = wThread;
            if (writeLogThread3 != null) {
                writeLogThread3.setName(THREAD_NAME);
            }
            try {
                System.loadLibrary("yylog");
            }
            catch (Throwable e) {
                e.printStackTrace();
                Log.w((String)"FileWriter", (String)"load yylog.so failed!!!");
                mInited.set(false);
            }
            mInited.set(true);
        }
    }

    public final void open(@NotNull String logDir, @NotNull String mmapDir, @NotNull String namePrefix, int logLevel, @NotNull String publicKey) {
        Intrinsics.checkParameterIsNotNull((Object)logDir, (String)"logDir");
        Intrinsics.checkParameterIsNotNull((Object)mmapDir, (String)"mmapDir");
        Intrinsics.checkParameterIsNotNull((Object)namePrefix, (String)"namePrefix");
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        if (!mInited.get()) {
            return;
        }
        mProcessId = Process.myPid();
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"Looper.getMainLooper()");
        Thread thread = looper.getThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Looper.getMainLooper().thread");
        mMainTid = thread.getId();
        BundleMessage bundleMessage = BundleMessage.Companion.obtain();
        FileWriter fileWriter = this;
        boolean bl = false;
        boolean bl2 = false;
        BundleMessage $this$apply = bundleMessage;
        boolean bl3 = false;
        $this$apply.setWhat(1);
        $this$apply.setLogDir(logDir);
        $this$apply.setMmapDir(mmapDir);
        $this$apply.setNamePrefix(namePrefix);
        $this$apply.setLevel(logLevel);
        $this$apply.setPublicKey(publicKey);
        BundleMessage bundleMessage2 = bundleMessage;
        fileWriter.postMessage(bundleMessage2);
    }

    public final void flush(@NotNull IKLogFlush flushCallback) {
        Intrinsics.checkParameterIsNotNull((Object)flushCallback, (String)"flushCallback");
        if (!mInited.get()) {
            return;
        }
        BundleMessage bundleMessage = BundleMessage.Companion.obtain();
        FileWriter fileWriter = this;
        boolean bl = false;
        boolean bl2 = false;
        BundleMessage $this$apply = bundleMessage;
        boolean bl3 = false;
        $this$apply.setWhat(2);
        $this$apply.setFlushCallback(flushCallback);
        BundleMessage bundleMessage2 = bundleMessage;
        fileWriter.postMessage(bundleMessage2);
    }

    public final void flush() {
        if (!mInited.get()) {
            return;
        }
        BundleMessage bundleMessage = BundleMessage.Companion.obtain();
        FileWriter fileWriter = this;
        boolean bl = false;
        boolean bl2 = false;
        BundleMessage $this$apply = bundleMessage;
        boolean bl3 = false;
        $this$apply.setWhat(2);
        BundleMessage bundleMessage2 = bundleMessage;
        fileWriter.postMessage(bundleMessage2);
    }

    public final void close() {
        if (!mInited.get()) {
            return;
        }
        BundleMessage bundleMessage = BundleMessage.Companion.obtain();
        FileWriter fileWriter = this;
        boolean bl = false;
        boolean bl2 = false;
        BundleMessage $this$apply = bundleMessage;
        boolean bl3 = false;
        $this$apply.setWhat(3);
        BundleMessage bundleMessage2 = bundleMessage;
        fileWriter.postMessage(bundleMessage2);
    }

    public final void setLogLevel(int logLevel) {
        if (!mInited.get()) {
            return;
        }
        BundleMessage bundleMessage = BundleMessage.Companion.obtain();
        FileWriter fileWriter = this;
        boolean bl = false;
        boolean bl2 = false;
        BundleMessage $this$apply = bundleMessage;
        boolean bl3 = false;
        $this$apply.setWhat(4);
        $this$apply.setLevel(logLevel);
        BundleMessage bundleMessage2 = bundleMessage;
        fileWriter.postMessage(bundleMessage2);
    }

    public final void setFileMaxSize(int size) {
        if (!mInited.get()) {
            return;
        }
        BundleMessage bundleMessage = BundleMessage.Companion.obtain();
        FileWriter fileWriter = this;
        boolean bl = false;
        boolean bl2 = false;
        BundleMessage $this$apply = bundleMessage;
        boolean bl3 = false;
        $this$apply.setWhat(5);
        $this$apply.setSize(size);
        BundleMessage bundleMessage2 = bundleMessage;
        fileWriter.postMessage(bundleMessage2);
    }

    public final void useConsoleLog(boolean use) {
        if (!mInited.get()) {
            return;
        }
        BundleMessage bundleMessage = BundleMessage.Companion.obtain();
        FileWriter fileWriter = this;
        boolean bl = false;
        boolean bl2 = false;
        BundleMessage $this$apply = bundleMessage;
        boolean bl3 = false;
        $this$apply.setUse(use);
        $this$apply.setWhat(6);
        BundleMessage bundleMessage2 = bundleMessage;
        fileWriter.postMessage(bundleMessage2);
    }

    public final void v(@NotNull String tag, @NotNull String fileName, @NotNull String funcName, int line, long tid, @NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (!mInited.get()) {
            return;
        }
        this.logWrite(LogLevel.INSTANCE.getLEVEL_VERBOSE(), tag, fileName, funcName, line, mProcessId, tid, mMainTid, msg);
    }

    public final void v(@NotNull String tag, @NotNull String fileName, @NotNull String funcName, int line, long tid, @NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        if (!mInited.get()) {
            return;
        }
        this.logWrite(LogLevel.INSTANCE.getLEVEL_VERBOSE(), tag, fileName, funcName, line, mProcessId, tid, mMainTid, format, Arrays.copyOf(args, args.length));
    }

    public final void i(@NotNull String tag, @NotNull String fileName, @NotNull String funcName, int line, long tid, @NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (!mInited.get()) {
            return;
        }
        this.logWrite(LogLevel.INSTANCE.getLEVEL_INFO(), tag, fileName, funcName, line, mProcessId, tid, mMainTid, msg);
    }

    public final void i(@NotNull String tag, @NotNull String fileName, @NotNull String funcName, int line, long tid, @NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        if (!mInited.get()) {
            return;
        }
        this.logWrite(LogLevel.INSTANCE.getLEVEL_INFO(), tag, fileName, funcName, line, mProcessId, tid, mMainTid, format, Arrays.copyOf(args, args.length));
    }

    public final void d(@NotNull String tag, @NotNull String fileName, @NotNull String funcName, int line, long tid, @NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (!mInited.get()) {
            return;
        }
        this.logWrite(LogLevel.INSTANCE.getLEVEL_DEBUG(), tag, fileName, funcName, line, mProcessId, tid, mMainTid, msg);
    }

    public final void d(@NotNull String tag, @NotNull String fileName, @NotNull String funcName, int line, long tid, @NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        if (!mInited.get()) {
            return;
        }
        this.logWrite(LogLevel.INSTANCE.getLEVEL_DEBUG(), tag, fileName, funcName, line, mProcessId, tid, mMainTid, format, Arrays.copyOf(args, args.length));
    }

    public final void w(@NotNull String tag, @NotNull String fileName, @NotNull String funcName, int line, long tid, @NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (!mInited.get()) {
            return;
        }
        this.logWrite(LogLevel.INSTANCE.getLEVEL_WARN(), tag, fileName, funcName, line, mProcessId, tid, mMainTid, msg);
    }

    public final void w(@NotNull String tag, @NotNull String fileName, @NotNull String funcName, int line, long tid, @NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        if (!mInited.get()) {
            return;
        }
        this.logWrite(LogLevel.INSTANCE.getLEVEL_WARN(), tag, fileName, funcName, line, mProcessId, tid, mMainTid, format, Arrays.copyOf(args, args.length));
    }

    public final void e(@NotNull String tag, @NotNull String fileName, @NotNull String funcName, int line, long tid, @NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (!mInited.get()) {
            return;
        }
        this.logWrite(LogLevel.INSTANCE.getLEVEL_ERROR(), tag, fileName, funcName, line, mProcessId, tid, mMainTid, msg);
    }

    public final void e(@NotNull String tag, @NotNull String fileName, @NotNull String funcName, int line, long tid, @NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        if (!mInited.get()) {
            return;
        }
        this.logWrite(LogLevel.INSTANCE.getLEVEL_ERROR(), tag, fileName, funcName, line, mProcessId, tid, mMainTid, format, Arrays.copyOf(args, args.length));
    }

    private final void logWrite(int level, String tag, String fileName, String funcName, int line, int pid, long tid, long maintid, String msg) {
        BundleMessage bundleMessage = BundleMessage.Companion.obtain();
        FileWriter fileWriter = this;
        boolean bl = false;
        boolean bl2 = false;
        BundleMessage $this$apply = bundleMessage;
        boolean bl3 = false;
        $this$apply.setWhat(7);
        $this$apply.setLevel(level);
        $this$apply.setTag(tag);
        $this$apply.setFileName(fileName);
        $this$apply.setFuncName(funcName);
        $this$apply.setMsg(msg);
        $this$apply.setLine(line);
        $this$apply.setPid(pid);
        $this$apply.setTid(tid);
        $this$apply.setMid(maintid);
        BundleMessage bundleMessage2 = bundleMessage;
        fileWriter.postMessage(bundleMessage2);
    }

    private final void logWrite(int level, String tag, String fileName, String funcName, int line, int pid, long tid, long maintid, String format, Object ... args) {
        BundleMessage bundleMessage = BundleMessage.Companion.obtain();
        FileWriter fileWriter = this;
        boolean bl = false;
        boolean bl2 = false;
        BundleMessage $this$apply = bundleMessage;
        boolean bl3 = false;
        $this$apply.setWhat(7);
        $this$apply.setLevel(level);
        $this$apply.setTag(tag);
        $this$apply.setFileName(fileName);
        $this$apply.setFuncName(funcName);
        $this$apply.setFormat(format);
        $this$apply.setArgs(args);
        $this$apply.setLine(line);
        $this$apply.setPid(pid);
        $this$apply.setTid(tid);
        $this$apply.setMid(maintid);
        BundleMessage bundleMessage2 = bundleMessage;
        fileWriter.postMessage(bundleMessage2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void postMessage(BundleMessage msg) {
        block6: {
            mQueue.add(msg);
            try {
                if (!lock.tryLock()) break block6;
                try {
                    condition.signal();
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "";
                }
                Log.w((String)"postMessage", (String)string);
            }
        }
    }

    private FileWriter() {
    }

    static {
        FileWriter fileWriter;
        INSTANCE = fileWriter = new FileWriter();
        mInited = new AtomicBoolean(false);
        mQueue = new LinkedBlockingQueue();
        lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        Intrinsics.checkExpressionValueIsNotNull((Object)condition, (String)"lock.newCondition()");
        FileWriter.condition = condition;
    }
}

