/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.klog.hide.util;

import android.annotation.SuppressLint;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.klog.api.ILog;
import tv.athena.klog.api.KLog;
import tv.athena.klog.hide.impl.LogConfig;
import tv.athena.klog.hide.impl.LogImpl;
import tv.athena.klog.hide.util.LogCompress;
import tv.athena.klog.hide.util.LogManager;
import tv.athena.klog.hide.util.TimeComparator;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u0006\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u001a\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ltv/athena/klog/hide/util/LogManager;", "", "()V", "DAYS_COMPRESSED", "", "DAYS_DELETE", "LOG_DATA_REGEX", "Lkotlin/text/Regex;", "getLOG_DATA_REGEX", "()Lkotlin/text/Regex;", "LOG_DATE_WITH_MINUTE_FORMAT_STR", "", "LOG_EXT", "TAG", "clearService", "Ljava/util/concurrent/ScheduledExecutorService;", "compressLog", "", "file", "Ljava/io/File;", "end", "isInvalidFile", "", "overflowCallback", "logDir", "rollCacheLogs", "start", "klog_release"})
public final class LogManager {
    private static final String LOG_DATE_WITH_MINUTE_FORMAT_STR = "yyyy_MM_dd_HH_mm";
    private static final long DAYS_DELETE = 604800000L;
    private static final long DAYS_COMPRESSED = 86400000L;
    @NotNull
    private static final Regex LOG_DATA_REGEX;
    private static final String LOG_EXT = ".txt";
    private static final String TAG = "LogManager";
    private static ScheduledExecutorService clearService;
    public static final LogManager INSTANCE;

    @NotNull
    public final Regex getLOG_DATA_REGEX() {
        return LOG_DATA_REGEX;
    }

    public final void start() {
        KLog.INSTANCE.setMLogImpl((ILog)new LogImpl());
        clearService.scheduleAtFixedRate(start.1.INSTANCE, 2L, 30L, TimeUnit.MINUTES);
    }

    public final void end() {
        clearService.shutdown();
    }

    public final void rollCacheLogs(@Nullable String logDir) {
        String string = logDir;
        if (string == null) {
            return;
        }
        File file = new File(string);
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        if (!$this$apply.exists()) {
            return;
        }
        Object[] objectArray = $this$apply.listFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"listFiles()");
        List list = ArraysKt.filterNotNull((Object[])objectArray);
        boolean bl4 = false;
        boolean bl5 = false;
        List it = list;
        boolean bl6 = false;
        Iterable $this$forEach$iv = it;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it2 = (File)element$iv;
            boolean bl7 = false;
            if (INSTANCE.isInvalidFile(it2)) {
                it2.delete();
                KLog.i((String)TAG, (String)"delete more 7Day and invaild file");
                continue;
            }
            if (System.currentTimeMillis() - it2.lastModified() <= 86400000L) continue;
            INSTANCE.compressLog(it2);
        }
        this.overflowCallback(logDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInvalidFile(File file) {
        if (System.currentTimeMillis() - file.lastModified() > 604800000L) return true;
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        if (!StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) {
            String string2 = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
            if (!StringsKt.endsWith$default((String)string2, (String)LOG_EXT, (boolean)false, (int)2, null)) return true;
        }
        String string3 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.name");
        if (!StringsKt.endsWith$default((String)string3, (String)".zip", (boolean)false, (int)2, null)) return false;
        if (file.length() >= (long)200) return false;
        return true;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private final void compressLog(File file) {
        File file2 = file;
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file2;
        boolean bl3 = false;
        String string = $this$apply.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        if (StringsKt.endsWith$default((String)string, (String)LOG_EXT, (boolean)false, (int)2, null)) {
            String string2 = $this$apply.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            CharSequence charSequence = string2;
            String string3 = new SimpleDateFormat(LOG_DATE_WITH_MINUTE_FORMAT_STR).format(new Date());
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"SimpleDateFormat(LOG_DAT\u2026          .format(Date())");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null)) {
                try {
                    LogCompress.INSTANCE.compress($this$apply);
                    $this$apply.delete();
                }
                catch (Exception e) {
                    KLog.w((String)TAG, (String)"LogCompress", (Object[])new Object[]{e});
                }
            }
        }
    }

    private final void overflowCallback(String logDir) {
        long size = 0L;
        String string = logDir;
        if (string == null) {
            return;
        }
        File[] fileArray = new File(string);
        boolean bl = false;
        boolean bl2 = false;
        File[] $this$run = fileArray;
        boolean bl3 = false;
        if (!$this$run.exists()) {
            return;
        }
        File[] child = $this$run.listFiles();
        Arrays.sort(child, new TimeComparator());
        fileArray = child;
        bl = false;
        bl2 = false;
        File[] it = fileArray;
        boolean bl4 = false;
        for (File index : it) {
            if (size + index.length() > LogConfig.INSTANCE.getLogCacheMaxSize()) {
                index.delete();
                KLog.i((String)TAG, (String)"delete more 100M zip");
                continue;
            }
            size += index.length();
        }
    }

    private LogManager() {
    }

    static {
        LogManager logManager;
        INSTANCE = logManager = new LogManager();
        LOG_DATA_REGEX = new Regex("_.*_(19|20)\\d{2}_[0-2]{2}_[0-9]{2}_[0-9]{2}_[0-9]{2}");
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, clearService.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"Executors.newScheduledTh\u2026Thread(r, \"logkit\")\n    }");
        clearService = scheduledExecutorService;
    }
}

