package tv.athena.klog.api

/**
 * Created by deh001 on 2018/5/14
 *
 * 对外log接口
 *
 */
object KLog {

    var mLogImpl: ILog? = null

    @JvmStatic
    fun v(tag: String, message: () -> Any?) {
        mLogImpl?.v(tag, message)
    }

    @JvmStatic
    fun v(tag: String, format: String, vararg args: Any?) {
        mLogImpl?.v(tag, format, *args)
    }

    @JvmStatic
    fun v(tag: String, message: String) {
        mLogImpl?.v(tag, message)
    }

    @JvmStatic
    fun i(tag: String, message: () -> Any?) {
        mLogImpl?.i(tag, message)
    }

    @JvmStatic
    fun i(tag: String, format: String, vararg args: Any?) {
        mLogImpl?.i(tag, format, *args)
    }

    @JvmStatic
    fun i(tag: String, message: String) {
        mLogImpl?.i(tag, message)
    }

    @JvmStatic
    fun d(tag: String, message: () -> Any?) {
        mLogImpl?.d(tag, message)
    }

    @JvmStatic
    fun d(tag: String, format: String, vararg args: Any?) {
        mLogImpl?.d(tag, format, *args)
    }

    @JvmStatic
    fun d(tag: String, message: String) {
        mLogImpl?.d(tag, message)
    }

    @JvmStatic
    fun w(tag: String, message: () -> Any?) {
        mLogImpl?.w(tag, message)
    }

    @JvmStatic
    fun w(tag: String, format: String, vararg args: Any?) {
        mLogImpl?.w(tag, format, *args)
    }

    @JvmStatic
    fun w(tag: String, message: String) {
        mLogImpl?.w(tag, message)
    }

    @JvmStatic
    fun e(tag: String, message: () -> Any?, error: Throwable? = null) {
        mLogImpl?.e(tag, message, error)
    }

    @JvmStatic
    fun e(tag: String, message: String) {
        mLogImpl?.e(tag, message)
    }

    @JvmStatic
    fun e(tag: String, format: String, vararg args: Any?) {
        mLogImpl?.e(tag, format, null, *args)
    }

    @JvmStatic
    fun e(tag: String, format: String, error: Throwable? = null, vararg args: Any?) {
        mLogImpl?.e(tag, format, error, *args)
    }
}