package tv.athena.klog.api

import java.io.File

/**
 * Created by deh001 on 2018/5/12
 *
 * Log对外服务，提供log初始化、获取文件log列表及flush所有log的功能
 *
 * 外部使用：
 *          初始化
 *          Axis.getService(ILogService::class.java).config()
 *              .processTag("app_main")
 *              .logLevel(LogLevel.LEVEL_INFO)
 *              .fileMaxSize(4 * 1024 * 1024)
 *              .apply()
 *
 *              Axis.getService(ILogService::class.java).config().apply()
 *
 *          使用
 *          KLog.i(TAG) { "this a test log" }
 *          KLog.e(TAG, "this is a test log");
 *
 */
interface ILogService {

    /**
     * 当前的LOG配置，可获取进行修改，修改完成后调用apply生效
     * @return 返回当前配置实例
     */
    fun config(): ILogConfig

    /**
     * 获取log文件所在的目录
     * @return log文件目录
     */
    fun catalog(): String?

    /**
     * 获取当前APP文件log列表
     * @return log文件列表，按时间倒序排列
     */
    fun fileLogList(): Array<File>

    /**
     * 获取当前APP指定进程标识的文件log列表
     * @param processId log进程标识
     * @return log文件列表，按时间倒序排列
     */
    fun fileLogList(processId: String): Array<File>

    /**
     * 异步flush缓存，确保缓存的LOG全部输出完毕
     */
    fun flush()

    /**
     * 异步flush缓存，带回调
     * */
    fun flush(flushCallback: IKLogFlush)

    /**
     * 同步阻塞等待flush执行完毕
     */
    fun flushBlocking(milliseconds: Long)
}