/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc;

import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.annotation.ServiceRegister;
import tv.athena.ipc.api.IPCApi;
import tv.athena.ipc.api.IPCListener;
import tv.athena.ipc.api.IPCService;
import tv.athena.ipc.internal.Channel;
import tv.athena.ipc.internal.IIPCService;
import tv.athena.ipc.internal.IIPCServiceCallback;
import tv.athena.ipc.internal.IPCInvocationHandler;
import tv.athena.ipc.internal.Mail;
import tv.athena.ipc.internal.Reply;
import tv.athena.ipc.receiver.Receiver;
import tv.athena.ipc.receiver.ReceiverDesignator;
import tv.athena.ipc.sender.Sender;
import tv.athena.ipc.sender.SenderDesignator;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.IPCGc;
import tv.athena.ipc.util.ObjectCenter;
import tv.athena.ipc.util.TypeCenter;
import tv.athena.ipc.util.TypeUtils;
import tv.athena.ipc.wrapper.ObjectWrapper;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0001\u0018\u0000 <2\u00020\u0001:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0002J\b\u0010\u0014\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000b2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J*\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J \u0010\u001b\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000b2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0016J;\u0010\u001f\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u00122\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%JK\u0010&\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u00122\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010'JC\u0010(\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u00122\u0006\u0010)\u001a\u00020\u00192\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010*JS\u0010+\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u00122\u0006\u0010)\u001a\u00020\u00192\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010,J)\u0010-\u001a\u0002H \"\u0004\b\u0000\u0010 2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010.\u001a\u00020/\u00a2\u0006\u0002\u00100J#\u00101\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u0012H\u0016\u00a2\u0006\u0002\u00102J3\u00103\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u0012H\u0016\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u00106\u001a\u000207H\u0016J\u0018\u00106\u001a\u0002072\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016J;\u00108\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u00122\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%JK\u00109\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u00122\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010'J\u0014\u0010:\u001a\u00020\r2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0010\u0010;\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Ltv/athena/ipc/IPCImpl;", "Ltv/athena/ipc/api/IPCApi;", "()V", "CHANNEL", "Ltv/athena/ipc/internal/Channel;", "kotlin.jvm.PlatformType", "IPC_GC", "Ltv/athena/ipc/util/IPCGc;", "TYPE_CENTER", "Ltv/athena/ipc/util/TypeCenter;", "sContext", "Landroid/content/Context;", "addIPCListener", "", "listener", "Ltv/athena/ipc/api/IPCListener;", "checkBound", "service", "Ljava/lang/Class;", "Ltv/athena/ipc/api/IPCService;", "checkInit", "connect", "context", "connectApp", "packageName", "", "serviceName", "disconnect", "getBinder", "Landroid/os/Binder;", "getContext", "getInstance", "T", "clazz", "parameters", "", "", "(Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", "getInstanceInService", "(Ljava/lang/Class;Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", "getInstanceWithMethodName", "methodName", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "getInstanceWithMethodNameInService", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "getProxy", "obj", "Ltv/athena/ipc/wrapper/ObjectWrapper;", "(Ljava/lang/Class;Ltv/athena/ipc/wrapper/ObjectWrapper;)Ljava/lang/Object;", "getUtilityClass", "(Ljava/lang/Class;)Ljava/lang/Object;", "getUtilityClassInService", "(Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/Object;", "init", "isConnected", "", "newInstance", "newInstanceInService", "register", "removeIPCListener", "Companion", "ipc_release"})
@ServiceRegister(serviceInterface=IPCApi.class)
public final class IPCImpl
implements IPCApi {
    private final TypeCenter TYPE_CENTER = TypeCenter.INSTANCE;
    private final Channel CHANNEL = Channel.getInstance();
    private final IPCGc IPC_GC = IPCGc.getInstance();
    private Context sContext;
    private static final String TAG = "Athena IPCImpl";
    public static final Companion Companion = new Companion(null);

    private final void checkInit() {
        if (this.sContext == null) {
            throw (Throwable)new IllegalStateException("IPC SDK  has not been initialized.");
        }
    }

    public void register(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        this.checkInit();
        this.TYPE_CENTER.register(clazz);
    }

    @NotNull
    public Context getContext() {
        Context context = this.sContext;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        return context;
    }

    public void init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (this.sContext != null) {
            return;
        }
        this.sContext = context.getApplicationContext();
    }

    private final void checkBound(Class<? extends IPCService> service) {
        if (!this.CHANNEL.getBound(service)) {
            throw (Throwable)new IllegalStateException("Service Unavailable: You have not connected the service or the connection is not completed. You can set IPCListener to receive a callback when the connection is completed.");
        }
    }

    public final <T> T getProxy(@NotNull Class<? extends IPCService> service, @NotNull ObjectWrapper obj) {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Class<?> clazz2 = clazz = obj.getObjectClass();
        Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"clazz");
        Object proxy = Proxy.newProxyInstance(clazz2.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new IPCInvocationHandler(service, obj));
        this.IPC_GC.register(service, proxy, obj.getTimeStamp());
        return (T)proxy;
    }

    @Nullable
    public <T> T newInstance(@NotNull Class<T> clazz, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return this.newInstanceInService(IPCService.IPCService0.class, clazz, Arrays.copyOf(parameters, parameters.length));
    }

    @Nullable
    public <T> T newInstanceInService(@NotNull Class<? extends IPCService> service, @NotNull Class<T> clazz, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        TypeUtils.validateServiceInterface(clazz);
        this.checkBound(service);
        ObjectWrapper obj = new ObjectWrapper(clazz, 0);
        Sender sender = SenderDesignator.getPostOffice(service, 0, obj);
        try {
            Reply reply = sender.send(null, parameters);
            if (reply != null && !reply.success()) {
                Log.e((String)TAG, (String)("Error occurs during creating instance. Error code: " + reply.getErrorCode()));
                Log.e((String)TAG, (String)("Error message: " + reply.getMessage()));
                return null;
            }
        }
        catch (IPCException e) {
            Log.e((String)TAG, (String)("Error message: " + e.getMessage()));
            return null;
        }
        obj.setType(3);
        return this.getProxy(service, obj);
    }

    @Nullable
    public <T> T getInstanceInService(@NotNull Class<? extends IPCService> service, @NotNull Class<T> clazz, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return this.getInstanceWithMethodNameInService(service, clazz, "", Arrays.copyOf(parameters, parameters.length));
    }

    @Nullable
    public <T> T getInstance(@NotNull Class<T> clazz, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return this.getInstanceInService(IPCService.IPCService0.class, clazz, Arrays.copyOf(parameters, parameters.length));
    }

    @Nullable
    public <T> T getInstanceWithMethodName(@NotNull Class<T> clazz, @NotNull String methodName, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return this.getInstanceWithMethodNameInService(IPCService.IPCService0.class, clazz, methodName, Arrays.copyOf(parameters, parameters.length));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T> T getInstanceWithMethodNameInService(@NotNull Class<? extends IPCService> service, @NotNull Class<T> clazz, @NotNull String methodName, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        TypeUtils.validateServiceInterface(clazz);
        this.checkBound(service);
        ObjectWrapper obj = new ObjectWrapper(clazz, 1);
        Sender sender = SenderDesignator.getPostOffice(service, 1, obj);
        int length = parameters.length;
        Object[] tmp = new Object[length + 1];
        tmp[0] = methodName;
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            tmp[i + true] = parameters[i];
            ++i;
        }
        try {
            Reply reply = sender.send(null, tmp);
            if (reply != null && !reply.success()) {
                Log.e((String)TAG, (String)("Error occurs during getting instance. Error code: " + reply.getErrorCode()));
                Log.e((String)TAG, (String)("Error message: " + reply.getMessage()));
                return null;
            }
        }
        catch (IPCException e) {
            Log.e((String)TAG, (String)("Error message: " + e.getMessage()));
            return null;
        }
        obj.setType(3);
        return this.getProxy(service, obj);
    }

    @Nullable
    public <T> T getUtilityClass(@NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return this.getUtilityClassInService(IPCService.IPCService0.class, clazz);
    }

    @Nullable
    public <T> T getUtilityClassInService(@NotNull Class<? extends IPCService> service, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        TypeUtils.validateServiceInterface(clazz);
        this.checkBound(service);
        ObjectWrapper obj = new ObjectWrapper(clazz, 5);
        Sender sender = SenderDesignator.getPostOffice(service, 2, obj);
        try {
            Reply reply = sender.send(null, null);
            if (reply != null && !reply.success()) {
                Log.e((String)TAG, (String)("Error occurs during getting utility class. Error code: " + reply.getErrorCode()));
                Log.e((String)TAG, (String)("Error message: " + reply.getMessage()));
                return null;
            }
        }
        catch (IPCException e) {
            Log.e((String)TAG, (String)("Error message: " + e.getMessage()));
            return null;
        }
        obj.setType(4);
        return this.getProxy(service, obj);
    }

    public void connect(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.connectApp(context, null, IPCService.IPCService0.class);
    }

    public void connect(@NotNull Context context, @NotNull Class<? extends IPCService> service) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        this.connectApp(context, null, service);
    }

    public void connectApp(@NotNull Context context, @NotNull String packageName, @NotNull String serviceName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        try {
            Class<?> clazz = Class.forName(serviceName);
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out tv.athena.ipc.api.IPCService>");
            }
            this.connectApp(context, packageName, clazz);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Error message: " + e.getMessage()));
        }
    }

    public void connectApp(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        this.connectApp(context, packageName, IPCService.IPCService0.class);
    }

    public void connectApp(@NotNull Context context, @Nullable String packageName, @NotNull Class<? extends IPCService> service) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        this.init(context);
        this.CHANNEL.bind(context.getApplicationContext(), packageName, service);
    }

    public void disconnect(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.disconnect(context, IPCService.IPCService0.class);
    }

    public void disconnect(@NotNull Context context, @NotNull Class<? extends IPCService> service) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        this.CHANNEL.unbind(context.getApplicationContext(), service);
    }

    public boolean isConnected() {
        return this.isConnected(IPCService.IPCService0.class);
    }

    public boolean isConnected(@NotNull Class<? extends IPCService> service) {
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        return this.CHANNEL.isConnected(service);
    }

    public void addIPCListener(@NotNull IPCListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.CHANNEL.addIPCListener(listener);
    }

    public void removeIPCListener(@NotNull IPCListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.CHANNEL.removeIPCListener(listener);
    }

    @NotNull
    public Binder getBinder() {
        return new IIPCService.Stub(){
            private final ObjectCenter OBJECT_CENTER;
            private final ConcurrentHashMap<Integer, IIPCServiceCallback> mCallbacks;

            @Nullable
            public Reply send(@NotNull Mail mail) {
                Reply reply;
                Intrinsics.checkParameterIsNotNull((Object)mail, (String)"mail");
                try {
                    Receiver receiver = ReceiverDesignator.getReceiver(mail.getObject());
                    int pid = mail.getPid();
                    IIPCServiceCallback callback = this.mCallbacks.get(pid);
                    if (callback != null) {
                        receiver.setIPCServiceCallback(callback);
                    }
                    reply = receiver.action(mail.getTimeStamp(), mail.getMethod(), mail.getParameters());
                }
                catch (IPCException e) {
                    e.printStackTrace();
                    Log.e((String)"Athena IPCImpl", (String)("Error message: " + e.getMessage()));
                    reply = new Reply(e.getErrorCode(), e.getMessage());
                }
                return reply;
            }

            public void register(@Nullable IIPCServiceCallback callback, int pid) throws RemoteException {
                Map map = this.mCallbacks;
                Integer n = pid;
                IIPCServiceCallback iIPCServiceCallback = callback;
                map.put(n, iIPCServiceCallback);
            }

            public void gc(@Nullable List<Long> timeStamps) throws RemoteException {
                this.OBJECT_CENTER.deleteObjects(timeStamps);
            }
            {
                this.OBJECT_CENTER = ObjectCenter.INSTANCE;
                this.mCallbacks = new ConcurrentHashMap<K, V>();
            }
        };
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltv/athena/ipc/IPCImpl$Companion;", "", "()V", "TAG", "", "ipc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

