/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.receiver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import tv.athena.ipc.receiver.Receiver;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.TypeUtils;
import tv.athena.ipc.wrapper.MethodWrapper;
import tv.athena.ipc.wrapper.ObjectWrapper;
import tv.athena.ipc.wrapper.ParameterWrapper;

public class InstanceGettingReceiver
extends Receiver {
    private Method mMethod;
    private Class<?> mObjectClass;

    public InstanceGettingReceiver(ObjectWrapper objectWrapper) throws IPCException {
        super(objectWrapper);
        Class<?> clazz = TYPE_CENTER.getClassType(objectWrapper);
        TypeUtils.validateAccessible(clazz);
        this.mObjectClass = clazz;
    }

    @Override
    public void setMethod(MethodWrapper methodWrapper, ParameterWrapper[] parameterWrappers) throws IPCException {
        int length = parameterWrappers.length;
        Class[] parameterTypes = new Class[length];
        for (int i = 0; i < length; ++i) {
            parameterTypes[i] = TYPE_CENTER.getClassType(parameterWrappers[i]);
        }
        String methodName = methodWrapper.getName();
        Method method = TypeUtils.getMethodForGettingInstance(this.mObjectClass, methodName, parameterTypes);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IPCException(21, "Method " + method.getName() + " of class " + this.mObjectClass.getName() + " is not static. Only the static method can be invoked to get an instance.");
        }
        TypeUtils.validateAccessible(method);
        this.mMethod = method;
        this.mParametersType = this.mMethod.getGenericParameterTypes();
    }

    @Override
    protected Object invokeMethod() throws IPCException {
        ReflectiveOperationException exception;
        try {
            Object object = this.mMethod.invoke(null, this.getParameters());
            OBJECT_CENTER.putObject(this.getObjectTimeStamp(), object);
            return null;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        exception.printStackTrace();
        throw new IPCException(18, "Error occurs when invoking method " + this.mMethod + " to get an instance of " + this.mObjectClass.getName(), exception);
    }
}

