/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.util;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import tv.athena.ipc.api.annotation.ClassId;
import tv.athena.ipc.api.annotation.GetInstance;
import tv.athena.ipc.api.annotation.MethodId;
import tv.athena.ipc.api.annotation.WithinProcess;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.TypeCenter;
import tv.athena.ipc.wrapper.MethodWrapper;
import tv.athena.ipc.wrapper.ParameterWrapper;

public class TypeUtils {
    private static final HashSet<Class<?>> CONTEXT_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(Context.class);
            this.add(Application.class);
            this.add(Service.class);
        }
    };

    public static String getClassId(Class<?> clazz) {
        ClassId classId = clazz.getAnnotation(ClassId.class);
        if (classId != null) {
            return classId.value();
        }
        return clazz.getName();
    }

    public static String getMethodId(Method method) {
        MethodId methodId = method.getAnnotation(MethodId.class);
        if (methodId != null) {
            return methodId.value();
        }
        StringBuilder result = new StringBuilder(method.getName());
        result.append('(').append(TypeUtils.getMethodParameters(method.getParameterTypes())).append(')').append("return(").append(method.getReturnType().getName()).append(")");
        return result.toString();
    }

    private static String getClassName(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return "boolean";
        }
        if (clazz == Byte.class) {
            return "byte";
        }
        if (clazz == Character.class) {
            return "char";
        }
        if (clazz == Short.class) {
            return "short";
        }
        if (clazz == Integer.class) {
            return "int";
        }
        if (clazz == Long.class) {
            return "long";
        }
        if (clazz == Float.class) {
            return "float";
        }
        if (clazz == Double.class) {
            return "double";
        }
        if (clazz == Void.class) {
            return "void";
        }
        return clazz.getName();
    }

    public static String getMethodParameters(Class<?>[] classes) {
        StringBuilder result = new StringBuilder();
        int length = classes.length;
        if (length == 0) {
            return result.toString();
        }
        result.append(TypeUtils.getClassName(classes[0]));
        for (int i = 1; i < length; ++i) {
            result.append(",").append(TypeUtils.getClassName(classes[i]));
        }
        return result.toString();
    }

    public static boolean primitiveMatch(Class<?> class1, Class<?> class2) {
        if (!class1.isPrimitive() && !class2.isPrimitive()) {
            return false;
        }
        if (class1 == class2) {
            return true;
        }
        if (class1.isPrimitive()) {
            return TypeUtils.primitiveMatch(class2, class1);
        }
        if (class1 == Boolean.class && class2 == Boolean.TYPE) {
            return true;
        }
        if (class1 == Byte.class && class2 == Byte.TYPE) {
            return true;
        }
        if (class1 == Character.class && class2 == Character.TYPE) {
            return true;
        }
        if (class1 == Short.class && class2 == Short.TYPE) {
            return true;
        }
        if (class1 == Integer.class && class2 == Integer.TYPE) {
            return true;
        }
        if (class1 == Long.class && class2 == Long.TYPE) {
            return true;
        }
        if (class1 == Float.class && class2 == Float.TYPE) {
            return true;
        }
        if (class1 == Double.class && class2 == Double.TYPE) {
            return true;
        }
        return class1 == Void.class && class2 == Void.TYPE;
    }

    public static boolean classAssignable(Class<?>[] classes1, Class<?>[] classes2) {
        if (classes1.length != classes2.length) {
            return false;
        }
        int length = classes2.length;
        for (int i = 0; i < length; ++i) {
            if (classes2[i] == null || TypeUtils.primitiveMatch(classes1[i], classes2[i]) || classes1[i].isAssignableFrom(classes2[i])) continue;
            return false;
        }
        return true;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Class<?> returnType) throws IPCException {
        Method[] methods;
        Method result = null;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !TypeUtils.classAssignable(method.getParameterTypes(), parameterTypes)) continue;
            if (result == null) {
                result = method;
                continue;
            }
            throw new IPCException(8, "There are more than one method named " + methodName + " of the class " + clazz.getName() + " matching the parameters!");
        }
        if (result == null) {
            return result;
        }
        if (result.getReturnType() != returnType) {
            throw new IPCException(10, "The method named " + methodName + " of the class " + clazz.getName() + " matches the parameter types but not the return type. The return type is " + result.getReturnType().getName() + " but the required type is " + returnType.getName() + ". The method in the local interface must exactly match the method in the remote class.");
        }
        return result;
    }

    public static Method getMethodForGettingInstance(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws IPCException {
        Method[] methods = clazz.getMethods();
        Method result = null;
        for (Method method : methods) {
            String tmpName = method.getName();
            if ((!methodName.equals("") || !tmpName.equals("getInstance") && !method.isAnnotationPresent(GetInstance.class)) && (methodName.equals("") || !tmpName.equals(methodName)) || !TypeUtils.classAssignable(method.getParameterTypes(), parameterTypes)) continue;
            if (result == null) {
                result = method;
                continue;
            }
            throw new IPCException(11, "When getting instance, there are more than one method named " + methodName + " of the class " + clazz.getName() + " matching the parameters!");
        }
        if (result != null) {
            if (result.getReturnType() != clazz) {
                throw new IPCException(12, "When getting instance, the method named " + methodName + " of the class " + clazz.getName() + " matches the parameter types but not the return type. The return type is " + result.getReturnType().getName() + " but the required type is " + clazz.getName() + ".");
            }
            return result;
        }
        throw new IPCException(13, "When getting instance, the method named " + methodName + " of the class " + clazz.getName() + " is not found. The class must have a method for getting instance.");
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?>[] parameterTypes) throws IPCException {
        Constructor<?>[] constructors;
        Constructor<?> result = null;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (!TypeUtils.classAssignable(constructor.getParameterTypes(), parameterTypes)) continue;
            if (result != null) {
                throw new IPCException(14, "The class " + clazz.getName() + " has too many constructors whose  parameter types match the required types.");
            }
            result = constructor;
        }
        if (result == null) {
            throw new IPCException(15, "The class " + clazz.getName() + " do not have a constructor whose  parameter types match the required types.");
        }
        return result;
    }

    public static ParameterWrapper[] objectToWrapper(Object[] objects) throws IPCException {
        if (objects == null) {
            objects = new Object[]{};
        }
        int length = objects.length;
        ParameterWrapper[] parameterWrappers = new ParameterWrapper[length];
        for (int i = 0; i < length; ++i) {
            try {
                parameterWrappers[i] = new ParameterWrapper(objects[i]);
                continue;
            }
            catch (IPCException e) {
                e.printStackTrace();
                throw new IPCException(e.getErrorCode(), "Error happens at parameter encoding, and parameter index is " + i + ". See the stack trace for more information.", e);
            }
        }
        return parameterWrappers;
    }

    public static void validateClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class object is null.");
        }
        if (clazz.isPrimitive() || clazz.isInterface()) {
            return;
        }
        if (clazz.isAnnotationPresent(WithinProcess.class)) {
            throw new IllegalArgumentException("Error occurs when registering class " + clazz.getName() + ". Class with a WithinProcess annotation presented on it cannot be accessed from outside the process.");
        }
        if (clazz.isAnonymousClass()) {
            throw new IllegalArgumentException("Error occurs when registering class " + clazz.getName() + ". Anonymous class cannot be accessed from outside the process.");
        }
        if (clazz.isLocalClass()) {
            throw new IllegalArgumentException("Error occurs when registering class " + clazz.getName() + ". Local class cannot be accessed from outside the process.");
        }
        if (Context.class.isAssignableFrom(clazz)) {
            return;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("Error occurs when registering class " + clazz.getName() + ". Abstract class cannot be accessed from outside the process.");
        }
    }

    public static void validateServiceInterface(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class object is null.");
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Only interfaces can be passed as the parameters.");
        }
    }

    public static boolean arrayContainsAnnotation(Annotation[] annotations, Class<? extends Annotation> annotationClass) {
        if (annotations == null || annotationClass == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getContextClass(Class<?> clazz) throws IPCException {
        if (Activity.class.isAssignableFrom(clazz)) {
            throw new IPCException(23, " method parameters is only support application context ,you context is " + clazz + "  but not null,I can get it in other process , can you  ues Application context ?");
        }
        for (Class<?> tmp = clazz; tmp != Object.class; tmp = tmp.getSuperclass()) {
            if (!CONTEXT_CLASSES.contains(tmp)) continue;
            return tmp;
        }
        throw new IPCException(23, " method parameters is only support application context ,you context is " + clazz + "  but not null,I can get it in other process , can you  ues Application context ?");
    }

    public static void validateAccessible(Class<?> clazz) throws IPCException {
        if (clazz.isAnnotationPresent(WithinProcess.class)) {
            throw new IPCException(19, "Class " + clazz.getName() + " has a WithProcess annotation on it, so it cannot be accessed from outside the process.");
        }
    }

    public static void validateAccessible(Method method) throws IPCException {
        if (method.isAnnotationPresent(WithinProcess.class)) {
            throw new IPCException(20, "Method " + method.getName() + " of class " + method.getDeclaringClass().getName() + " has a WithProcess annotation on it, so it cannot be accessed from outside the process.");
        }
    }

    public static void validateAccessible(Constructor<?> constructor) throws IPCException {
        if (constructor.isAnnotationPresent(WithinProcess.class)) {
            throw new IPCException(20, "Constructor " + constructor.getName() + " of class " + constructor.getDeclaringClass().getName() + " has a WithProcess annotation on it, so it cannot be accessed from outside the process.");
        }
    }

    public static void methodParameterTypeMatch(Method method, MethodWrapper methodWrapper) throws IPCException {
        Class<?>[] parameterTypes;
        Class<?>[] requiredParameterTypes = TypeCenter.INSTANCE.getClassTypes(methodWrapper.getParameterTypes());
        if (requiredParameterTypes.length != (parameterTypes = method.getParameterTypes()).length) {
            throw new IPCException(9, "The number of method parameters do not match. Method " + method + " has " + parameterTypes.length + " parameters. The required method has " + requiredParameterTypes.length + " parameters.");
        }
        int length = requiredParameterTypes.length;
        for (int i = 0; i < length; ++i) {
            if (!(requiredParameterTypes[i].isPrimitive() || parameterTypes[i].isPrimitive() ? !TypeUtils.primitiveMatch(requiredParameterTypes[i], parameterTypes[i]) : requiredParameterTypes[i] != parameterTypes[i] && !TypeUtils.primitiveMatch(requiredParameterTypes[i], parameterTypes[i]))) continue;
            throw new IPCException(9, "The parameter type of method " + method + " do not match at index " + i + ".");
        }
    }

    public static void methodReturnTypeMatch(Method method, MethodWrapper methodWrapper) throws IPCException {
        Class<?> returnType = method.getReturnType();
        Class<?> requiredReturnType = TypeCenter.INSTANCE.getClassType(methodWrapper.getReturnType());
        if (returnType.isPrimitive() || requiredReturnType.isPrimitive() ? !TypeUtils.primitiveMatch(returnType, requiredReturnType) : requiredReturnType != returnType && !returnType.isAssignableFrom(requiredReturnType) && !requiredReturnType.isAssignableFrom(returnType) && !TypeUtils.primitiveMatch(returnType, requiredReturnType)) {
            throw new IPCException(10, "The return type of methods do not match. Method " + method + " return classloader :" + returnType.getClassLoader() + "type: " + returnType.getName() + ". The required is classloader " + requiredReturnType.getClassLoader() + "type: " + requiredReturnType.getName());
        }
    }

    public static void methodMatch(Method method, MethodWrapper methodWrapper) throws IPCException {
        TypeUtils.methodParameterTypeMatch(method, methodWrapper);
        TypeUtils.methodReturnTypeMatch(method, methodWrapper);
    }
}

