/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.sender;

import android.app.Application;
import android.content.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import tv.athena.ipc.api.IPCService;
import tv.athena.ipc.api.annotation.Background;
import tv.athena.ipc.api.annotation.WeakRef;
import tv.athena.ipc.internal.Channel;
import tv.athena.ipc.internal.Mail;
import tv.athena.ipc.internal.Reply;
import tv.athena.ipc.util.CallbackManager;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.TimeStampGenerator;
import tv.athena.ipc.util.TypeCenter;
import tv.athena.ipc.util.TypeUtils;
import tv.athena.ipc.wrapper.MethodWrapper;
import tv.athena.ipc.wrapper.ObjectWrapper;
import tv.athena.ipc.wrapper.ParameterWrapper;

public abstract class Sender {
    protected static final TypeCenter TYPE_CENTER = TypeCenter.INSTANCE;
    private static final Channel CHANNEL = Channel.getInstance();
    private static final CallbackManager CALLBACK_MANAGER = CallbackManager.INSTANCE;
    private long mTimeStamp;
    private ObjectWrapper mObject;
    private MethodWrapper mMethod;
    private ParameterWrapper[] mParameters;
    private Class<? extends IPCService> mService;

    public Sender(Class<? extends IPCService> service, ObjectWrapper object) {
        this.mService = service;
        this.mObject = object;
    }

    protected abstract MethodWrapper getMethodWrapper(Method var1, ParameterWrapper[] var2) throws IPCException;

    protected void setParameterWrappers(ParameterWrapper[] parameterWrappers) {
        this.mParameters = parameterWrappers;
    }

    private void registerClass(Method method) throws IPCException {
        Class<?>[] classes;
        if (method == null) {
            return;
        }
        for (Class<?> clazz : classes = method.getParameterTypes()) {
            if (!clazz.isInterface()) continue;
            TYPE_CENTER.register(clazz);
            this.registerCallbackMethodParameterTypes(clazz);
        }
        TYPE_CENTER.register(method.getReturnType());
    }

    private void registerCallbackMethodParameterTypes(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] parameterTypes;
            for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                TYPE_CENTER.register(parameterType);
            }
        }
    }

    private final ParameterWrapper[] getParameterWrappers(Method method, Object[] parameters) throws IPCException {
        int length = parameters.length;
        ParameterWrapper[] parameterWrappers = new ParameterWrapper[length];
        if (method != null) {
            Class<?>[] classes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < length; ++i) {
                Object parameter = parameters[i];
                if (classes[i].isInterface()) {
                    parameterWrappers[i] = parameter != null ? new ParameterWrapper(classes[i], null) : new ParameterWrapper((Object)null);
                    if (parameterAnnotations[i] == null || parameter == null) continue;
                    CALLBACK_MANAGER.addCallback(this.mTimeStamp, i, parameter, TypeUtils.arrayContainsAnnotation(parameterAnnotations[i], WeakRef.class), !TypeUtils.arrayContainsAnnotation(parameterAnnotations[i], Background.class));
                    continue;
                }
                if (Context.class.isAssignableFrom(classes[i])) {
                    if (parameter == null) {
                        parameterWrappers[i] = new ParameterWrapper(Application.class, null);
                        continue;
                    }
                    parameterWrappers[i] = new ParameterWrapper(TypeUtils.getContextClass(classes[i]), "application");
                    continue;
                }
                parameterWrappers[i] = new ParameterWrapper(parameters[i]);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                parameterWrappers[i] = new ParameterWrapper(parameters[i]);
            }
        }
        return parameterWrappers;
    }

    public final synchronized Reply send(Method method, Object[] parameters) throws IPCException {
        this.mTimeStamp = TimeStampGenerator.getTimeStamp();
        if (parameters == null) {
            parameters = new Object[]{};
        }
        ParameterWrapper[] parameterWrappers = this.getParameterWrappers(method, parameters);
        MethodWrapper methodWrapper = this.getMethodWrapper(method, parameterWrappers);
        this.registerClass(method);
        this.setParameterWrappers(parameterWrappers);
        Mail mail = new Mail(this.mTimeStamp, this.mObject, methodWrapper, this.mParameters);
        this.mMethod = methodWrapper;
        return CHANNEL.send(this.mService, mail);
    }

    public ObjectWrapper getObject() {
        return this.mObject;
    }
}

