/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.receiver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import tv.athena.ipc.receiver.Receiver;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.TypeUtils;
import tv.athena.ipc.wrapper.MethodWrapper;
import tv.athena.ipc.wrapper.ObjectWrapper;
import tv.athena.ipc.wrapper.ParameterWrapper;

public class UtilityReceiver
extends Receiver {
    private Method mMethod;
    private Class<?> mClass;

    public UtilityReceiver(ObjectWrapper objectWrapper) throws IPCException {
        super(objectWrapper);
        Class<?> clazz = TYPE_CENTER.getClassType(objectWrapper);
        TypeUtils.validateAccessible(clazz);
        this.mClass = clazz;
    }

    @Override
    protected void setMethod(MethodWrapper methodWrapper, ParameterWrapper[] parameterWrappers) throws IPCException {
        Method method = TYPE_CENTER.getMethod(this.mClass, methodWrapper);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IPCException(5, "Only static methods can be invoked on the utility class " + this.mClass.getName() + ". Please modify the method: " + this.mMethod);
        }
        TypeUtils.validateAccessible(method);
        this.mMethod = method;
    }

    @Override
    protected Object invokeMethod() throws IPCException {
        ReflectiveOperationException exception;
        try {
            return this.mMethod.invoke(null, this.getParameters());
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        exception.printStackTrace();
        throw new IPCException(18, "Error occurs when invoking method " + this.mMethod + ".", exception);
    }
}

