/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.receiver;

import android.content.Context;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import tv.athena.core.axis.Axis;
import tv.athena.ipc.api.IPCApi;
import tv.athena.ipc.internal.IIPCServiceCallback;
import tv.athena.ipc.internal.IPCCallbackInvocationHandler;
import tv.athena.ipc.internal.Reply;
import tv.athena.ipc.util.CodeUtils;
import tv.athena.ipc.util.IPCCallbackGc;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.ObjectCenter;
import tv.athena.ipc.util.TypeCenter;
import tv.athena.ipc.wrapper.MethodWrapper;
import tv.athena.ipc.wrapper.ObjectWrapper;
import tv.athena.ipc.wrapper.ParameterWrapper;

public abstract class Receiver {
    protected static final ObjectCenter OBJECT_CENTER = ObjectCenter.INSTANCE;
    protected static final TypeCenter TYPE_CENTER = TypeCenter.INSTANCE;
    protected static final IPCCallbackGc IPC_CALLBACK_GC = IPCCallbackGc.INSTANCE;
    private long mObjectTimeStamp;
    private Object[] mParameters;
    public Type[] mParametersType;
    private IIPCServiceCallback mCallback;

    public Receiver(ObjectWrapper objectWrapper) {
        this.mObjectTimeStamp = objectWrapper.getTimeStamp();
    }

    protected long getObjectTimeStamp() {
        return this.mObjectTimeStamp;
    }

    protected Object[] getParameters() {
        return this.mParameters;
    }

    public void setIPCServiceCallback(IIPCServiceCallback callback) {
        this.mCallback = callback;
    }

    private Object getProxy(Class<?> clazz, int index, long methodInvocationTimeStamp) {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new IPCCallbackInvocationHandler(methodInvocationTimeStamp, index, this.mCallback));
    }

    private static void registerCallbackReturnTypes(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            TYPE_CENTER.register(method.getReturnType());
        }
    }

    private void setParameters(long methodInvocationTimeStamp, ParameterWrapper[] parameterWrappers) throws IPCException {
        if (parameterWrappers == null) {
            this.mParameters = null;
        } else {
            int length = parameterWrappers.length;
            this.mParameters = new Object[length];
            for (int i = 0; i < length; ++i) {
                String data;
                ParameterWrapper parameterWrapper = parameterWrappers[i];
                if (parameterWrapper == null) {
                    this.mParameters[i] = null;
                    continue;
                }
                Class<?> clazz = TYPE_CENTER.getClassType(parameterWrapper);
                if (clazz != null && clazz.isInterface()) {
                    Receiver.registerCallbackReturnTypes(clazz);
                    this.mParameters[i] = this.getProxy(clazz, i, methodInvocationTimeStamp);
                    IPC_CALLBACK_GC.register(this.mCallback, this.mParameters[i], methodInvocationTimeStamp, i);
                    continue;
                }
                if (clazz != null && Context.class.isAssignableFrom(clazz)) {
                    data = parameterWrapper.getData();
                    if (data == null) {
                        this.mParameters[i] = null;
                        continue;
                    }
                    this.mParameters[i] = ((IPCApi)Axis.Companion.getService(IPCApi.class)).getContext();
                    continue;
                }
                data = parameterWrapper.getData();
                this.mParameters[i] = data == null ? null : CodeUtils.decode(data, this.mParametersType[i]);
            }
        }
    }

    protected abstract void setMethod(MethodWrapper var1, ParameterWrapper[] var2) throws IPCException;

    protected abstract Object invokeMethod() throws IPCException;

    public final Reply action(long methodInvocationTimeStamp, MethodWrapper methodWrapper, ParameterWrapper[] parameterWrappers) throws IPCException {
        this.setMethod(methodWrapper, parameterWrappers);
        this.setParameters(methodInvocationTimeStamp, parameterWrappers);
        Object result = this.invokeMethod();
        if (result instanceof Reply) {
            return (Reply)result;
        }
        if (result == null) {
            return null;
        }
        return new Reply(new ParameterWrapper(result));
    }
}

