/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.receiver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import tv.athena.ipc.internal.Reply;
import tv.athena.ipc.receiver.Receiver;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.TimeStampGenerator;
import tv.athena.ipc.util.TypeUtils;
import tv.athena.ipc.wrapper.MethodWrapper;
import tv.athena.ipc.wrapper.ObjectWrapper;
import tv.athena.ipc.wrapper.ParameterWrapper;

public class ObjectReceiver
extends Receiver {
    private Method mMethod;
    private Object mObject = OBJECT_CENTER.getObject(this.getObjectTimeStamp());
    private MethodWrapper methodWrapper;

    public ObjectReceiver(ObjectWrapper objectWrapper) {
        super(objectWrapper);
    }

    @Override
    public void setMethod(MethodWrapper methodWrapper, ParameterWrapper[] parameterWrappers) throws IPCException {
        Method method = TYPE_CENTER.getMethod(this.mObject.getClass(), methodWrapper);
        TypeUtils.validateAccessible(method);
        this.mMethod = method;
        this.methodWrapper = methodWrapper;
        this.mParametersType = this.mMethod.getGenericParameterTypes();
    }

    @Override
    protected Object invokeMethod() throws IPCException {
        ReflectiveOperationException exception;
        try {
            Object invoke = this.mMethod.invoke(this.mObject, this.getParameters());
            if (this.mMethod.getReturnType().isInterface()) {
                long returnTimeStamp = TimeStampGenerator.getReturnTimeStamp();
                OBJECT_CENTER.putObject(returnTimeStamp, invoke);
                return new Reply(returnTimeStamp);
            }
            return invoke;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        throw new IPCException(18, "Error occurs when invoking method " + this.mMethod + " on " + this.mObject, exception);
    }
}

