/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.internal;

import android.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import tv.athena.core.axis.Axis;
import tv.athena.ipc.IPCImpl;
import tv.athena.ipc.api.IPCApi;
import tv.athena.ipc.api.IPCService;
import tv.athena.ipc.internal.Reply;
import tv.athena.ipc.sender.Sender;
import tv.athena.ipc.sender.SenderDesignator;
import tv.athena.ipc.util.CodeUtils;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.wrapper.ObjectWrapper;

public class IPCInvocationHandler
implements InvocationHandler {
    private static final String TAG = "IPC_INVOCATION";
    private Sender mSender;
    private Class<? extends IPCService> service;

    public IPCInvocationHandler(Class<? extends IPCService> service, ObjectWrapper object) {
        this.service = service;
        this.mSender = SenderDesignator.getPostOffice(service, 3, object);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] objects) {
        try {
            Reply reply = this.mSender.send(method, objects);
            if (reply == null) {
                return null;
            }
            if (reply.success()) {
                if (method.getReturnType().isInterface()) {
                    ObjectWrapper objectWrapper = new ObjectWrapper(method.getReturnType(), 3);
                    objectWrapper.setTimeStamp(reply.getReturnTimeStamp());
                    return ((IPCImpl)Axis.Companion.getService(IPCApi.class)).getProxy(this.service, objectWrapper);
                }
                return CodeUtils.decode(reply.getResultByType(), method.getGenericReturnType());
            }
            Log.e((String)TAG, (String)("Error occurs. Error " + reply.getErrorCode() + ": \n" + reply.getMessage()));
            return null;
        }
        catch (IPCException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("Error occurs. Error " + e.getErrorCode() + ": \n" + e.getMessage()));
            return null;
        }
    }
}

