/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.internal;

import android.os.RemoteException;
import android.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import tv.athena.ipc.internal.CallbackMail;
import tv.athena.ipc.internal.IIPCServiceCallback;
import tv.athena.ipc.internal.Reply;
import tv.athena.ipc.util.CodeUtils;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.TypeUtils;
import tv.athena.ipc.wrapper.MethodWrapper;
import tv.athena.ipc.wrapper.ParameterWrapper;

public class IPCCallbackInvocationHandler
implements InvocationHandler {
    private static final String TAG = "HERMES_CALLBACK";
    private long mTimeStamp;
    private int mIndex;
    private IIPCServiceCallback mCallback;

    public IPCCallbackInvocationHandler(long timeStamp, int index, IIPCServiceCallback callback) {
        this.mTimeStamp = timeStamp;
        this.mIndex = index;
        this.mCallback = callback;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] objects) {
        try {
            MethodWrapper methodWrapper = new MethodWrapper(method);
            ParameterWrapper[] parameterWrappers = TypeUtils.objectToWrapper(objects);
            CallbackMail callbackMail = new CallbackMail(this.mTimeStamp, this.mIndex, methodWrapper, parameterWrappers);
            Reply reply = this.mCallback.callback(callbackMail);
            if (reply == null) {
                return null;
            }
            if (reply.success()) {
                return CodeUtils.decode(reply.getResultByType(), method.getGenericReturnType());
            }
            Log.e((String)TAG, (String)("Error occurs: " + reply.getMessage()));
            return null;
        }
        catch (RemoteException | IPCException e) {
            Log.e((String)TAG, (String)"Error occurs but does not crash the app.", (Throwable)e);
            return null;
        }
    }
}

