/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;
import tv.athena.ipc.internal.IIPCServiceCallback;
import tv.athena.ipc.internal.Mail;
import tv.athena.ipc.internal.Reply;

public interface IIPCService
extends IInterface {
    public Reply send(Mail var1) throws RemoteException;

    public void register(IIPCServiceCallback var1, int var2) throws RemoteException;

    public void gc(List<Long> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IIPCService {
        private static final String DESCRIPTOR = "tv.athena.ipc.internal.IIPCService";
        static final int TRANSACTION_send = 1;
        static final int TRANSACTION_register = 2;
        static final int TRANSACTION_gc = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IIPCService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin instanceof IIPCService) {
                return (IIPCService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    Mail arg0 = 0 != data.readInt() ? (Mail)Mail.CREATOR.createFromParcel(data) : null;
                    Reply result = this.send(arg0);
                    reply.writeNoException();
                    if (result != null) {
                        reply.writeInt(1);
                        result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = data.readStrongBinder();
                    IIPCServiceCallback arg1 = IIPCServiceCallback.Stub.asInterface(iBinder);
                    int pid = data.readInt();
                    this.register(arg1, pid);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    ClassLoader cl = this.getClass().getClassLoader();
                    ArrayList list = data.readArrayList(cl);
                    this.gc(list);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IIPCService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Reply send(Mail mail) throws RemoteException {
                Reply result;
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();
                try {
                    data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (mail != null) {
                        data.writeInt(1);
                        mail.writeToParcel(data, 0);
                    } else {
                        data.writeInt(0);
                    }
                    this.mRemote.transact(1, data, reply, 0);
                    reply.readException();
                    result = 0 != reply.readInt() ? (Reply)Reply.CREATOR.createFromParcel(reply) : null;
                }
                finally {
                    reply.recycle();
                    data.recycle();
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void register(IIPCServiceCallback callback, int pid) throws RemoteException {
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();
                try {
                    data.writeInterfaceToken(Stub.DESCRIPTOR);
                    data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    data.writeInt(pid);
                    this.mRemote.transact(2, data, reply, 0);
                    reply.readException();
                }
                finally {
                    reply.recycle();
                    data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void gc(List<Long> timeStamps) throws RemoteException {
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();
                try {
                    data.writeInterfaceToken(Stub.DESCRIPTOR);
                    data.writeList(timeStamps);
                    this.mRemote.transact(3, data, reply, 0);
                    reply.readException();
                }
                finally {
                    reply.recycle();
                    data.recycle();
                }
            }
        }
    }
}

