/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.wrapper;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.reflect.Method;
import tv.athena.ipc.api.annotation.MethodId;
import tv.athena.ipc.util.TypeUtils;
import tv.athena.ipc.wrapper.BaseWrapper;
import tv.athena.ipc.wrapper.TypeWrapper;

public class MethodWrapper
extends BaseWrapper
implements Parcelable {
    private TypeWrapper[] mParameterTypes;
    private TypeWrapper mReturnType;
    public static final Parcelable.Creator<MethodWrapper> CREATOR = new Parcelable.Creator<MethodWrapper>(){

        public MethodWrapper createFromParcel(Parcel in) {
            MethodWrapper methodWrapper = new MethodWrapper();
            methodWrapper.readFromParcel(in);
            return methodWrapper;
        }

        public MethodWrapper[] newArray(int size) {
            return new MethodWrapper[size];
        }
    };

    private MethodWrapper() {
    }

    public MethodWrapper(Method method) {
        this.setName(!method.isAnnotationPresent(MethodId.class), TypeUtils.getMethodId(method));
        Class<?>[] classes = method.getParameterTypes();
        if (classes == null) {
            classes = new Class[]{};
        }
        int length = classes.length;
        this.mParameterTypes = new TypeWrapper[length];
        for (int i = 0; i < length; ++i) {
            this.mParameterTypes[i] = new TypeWrapper(classes[i]);
        }
        this.mReturnType = new TypeWrapper(method.getReturnType());
    }

    public MethodWrapper(String methodName, Class<?>[] parameterTypes) {
        this.setName(true, methodName);
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        int length = parameterTypes.length;
        this.mParameterTypes = new TypeWrapper[length];
        for (int i = 0; i < length; ++i) {
            this.mParameterTypes[i] = new TypeWrapper(parameterTypes[i]);
        }
        this.mReturnType = null;
    }

    public MethodWrapper(Class<?>[] parameterTypes) {
        this.setName(false, "");
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        int length = parameterTypes.length;
        this.mParameterTypes = new TypeWrapper[length];
        for (int i = 0; i < length; ++i) {
            this.mParameterTypes[i] = parameterTypes[i] == null ? null : new TypeWrapper(parameterTypes[i]);
        }
        this.mReturnType = null;
    }

    public TypeWrapper[] getParameterTypes() {
        return this.mParameterTypes;
    }

    public TypeWrapper getReturnType() {
        return this.mReturnType;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
        parcel.writeParcelableArray((Parcelable[])this.mParameterTypes, flags);
        parcel.writeParcelable((Parcelable)this.mReturnType, flags);
    }

    @Override
    public void readFromParcel(Parcel in) {
        super.readFromParcel(in);
        ClassLoader classLoader = MethodWrapper.class.getClassLoader();
        Parcelable[] parcelables = in.readParcelableArray(classLoader);
        if (parcelables == null) {
            this.mParameterTypes = null;
        } else {
            int length = parcelables.length;
            this.mParameterTypes = new TypeWrapper[length];
            for (int i = 0; i < length; ++i) {
                this.mParameterTypes[i] = (TypeWrapper)parcelables[i];
            }
        }
        this.mReturnType = (TypeWrapper)in.readParcelable(classLoader);
    }
}

