/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.util;

import android.text.TextUtils;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.ipc.api.annotation.ClassId;
import tv.athena.ipc.api.annotation.MethodId;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.TypeUtils;
import tv.athena.ipc.wrapper.BaseWrapper;
import tv.athena.ipc.wrapper.MethodWrapper;
import tv.athena.ipc.wrapper.TypeWrapper;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rJ'\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u000f\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\b2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u00172\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0014\u0010\u0018\u001a\u00020\u00172\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u0014\u0010\u0019\u001a\u00020\u00172\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ltv/athena/ipc/util/TypeCenter;", "", "()V", "mAnnotatedClasses", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/lang/Class;", "mAnnotatedMethods", "Ljava/lang/reflect/Method;", "mRawClasses", "mRawMethods", "getClassType", "wrapper", "Ltv/athena/ipc/wrapper/BaseWrapper;", "getClassTypes", "", "wrappers", "([Ltv/athena/ipc/wrapper/BaseWrapper;)[Ljava/lang/Class;", "getMethod", "clazz", "methodWrapper", "Ltv/athena/ipc/wrapper/MethodWrapper;", "register", "", "registerClass", "registerMethod", "ipc_release"})
public final class TypeCenter {
    private static final ConcurrentHashMap<String, Class<?>> mAnnotatedClasses;
    private static final ConcurrentHashMap<String, Class<?>> mRawClasses;
    private static final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Method>> mAnnotatedMethods;
    private static final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Method>> mRawMethods;
    public static final TypeCenter INSTANCE;

    private final void registerClass(Class<?> clazz) {
        ClassId classId = clazz.getAnnotation(ClassId.class);
        if (classId == null) {
            String className = clazz.getName();
            mRawClasses.putIfAbsent(className, clazz);
        } else {
            String className = classId.value();
            mAnnotatedClasses.putIfAbsent(className, clazz);
        }
    }

    private final void registerMethod(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            String key;
            ConcurrentHashMap<String, Method> map;
            MethodId methodId = method.getAnnotation(MethodId.class);
            if (methodId == null) {
                mRawMethods.putIfAbsent(clazz, new ConcurrentHashMap());
                map = mRawMethods.get(clazz);
                key = TypeUtils.getMethodId(method);
                ConcurrentHashMap<String, Method> concurrentHashMap = map;
                if (concurrentHashMap != null) {
                    concurrentHashMap.putIfAbsent(key, method);
                }
                continue;
            }
            mAnnotatedMethods.putIfAbsent(clazz, new ConcurrentHashMap());
            map = mAnnotatedMethods.get(clazz);
            key = TypeUtils.getMethodId(method);
            ConcurrentHashMap<String, Method> concurrentHashMap = map;
            if (concurrentHashMap == null) continue;
            concurrentHashMap.putIfAbsent(key, method);
        }
    }

    public final void register(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        TypeUtils.validateClass(clazz);
        this.registerClass(clazz);
        this.registerMethod(clazz);
    }

    @Nullable
    public final Class<?> getClassType(@NotNull BaseWrapper wrapper) throws IPCException {
        Intrinsics.checkParameterIsNotNull((Object)wrapper, (String)"wrapper");
        String name = wrapper.getName();
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        if (wrapper.isName()) {
            Class<Object> clazz = mAnnotatedClasses.get(name);
            if (clazz == null) {
                clazz = mRawClasses.get(name);
            }
            if (clazz != null) {
                return clazz;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"boolean")) {
                clazz = Boolean.TYPE;
            } else if (Intrinsics.areEqual((Object)name, (Object)"byte")) {
                clazz = Byte.TYPE;
            } else if (Intrinsics.areEqual((Object)name, (Object)"char")) {
                clazz = Character.TYPE;
            } else if (Intrinsics.areEqual((Object)name, (Object)"short")) {
                clazz = Short.TYPE;
            } else if (Intrinsics.areEqual((Object)name, (Object)"int")) {
                clazz = Integer.TYPE;
            } else if (Intrinsics.areEqual((Object)name, (Object)"long")) {
                clazz = Long.TYPE;
            } else if (Intrinsics.areEqual((Object)name, (Object)"float")) {
                clazz = Float.TYPE;
            } else if (Intrinsics.areEqual((Object)name, (Object)"double")) {
                clazz = Double.TYPE;
            } else if (Intrinsics.areEqual((Object)name, (Object)"void")) {
                clazz = Void.TYPE;
            } else {
                try {
                    clazz = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    throw (Throwable)new IPCException(16, "Cannot find class " + name + ". Classes without ClassId annotation on it " + "should be located at the same package and have the same name, " + "EVEN IF the source code has been obfuscated by Proguard.");
                }
            }
            Class<Object> clazz2 = clazz;
            if (clazz2 == null) {
                Intrinsics.throwNpe();
            }
            mRawClasses.putIfAbsent(name, clazz2);
            return clazz;
        }
        Class<?> clazz = mAnnotatedClasses.get(name);
        if (clazz == null) {
            throw (Throwable)new IPCException(16, "Cannot find class with ClassId annotation on it. ClassId = " + name + ". Please add the same annotation on the corresponding class in the remote process" + " and register it. Have you forgotten to register the class?");
        }
        Class<?> clazz3 = clazz;
        return clazz3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Class<?>[] getClassTypes(@NotNull BaseWrapper[] wrappers) throws IPCException {
        Intrinsics.checkParameterIsNotNull((Object)wrappers, (String)"wrappers");
        Class[] classes = new Class[wrappers.length];
        int n = 0;
        int n2 = wrappers.length;
        while (n < n2) {
            void i;
            classes[i] = this.getClassType(wrappers[i]);
            ++i;
        }
        return classes;
    }

    @NotNull
    public final Method getMethod(@NotNull Class<?> clazz, @NotNull MethodWrapper methodWrapper) throws IPCException {
        Method method;
        ConcurrentHashMap<String, Method> methods;
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)methodWrapper, (String)"methodWrapper");
        String name = methodWrapper.getName();
        if (methodWrapper.isName()) {
            Method method2;
            ConcurrentHashMap<String, Method> methods2;
            mRawMethods.putIfAbsent(clazz, new ConcurrentHashMap());
            ConcurrentHashMap<String, Method> concurrentHashMap = methods2 = mRawMethods.get(clazz);
            if (concurrentHashMap == null) {
                Intrinsics.throwNpe();
            }
            if ((method2 = concurrentHashMap.get(name)) != null) {
                TypeUtils.methodReturnTypeMatch(method2, methodWrapper);
                return method2;
            }
            String string = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            int pos = StringsKt.indexOf$default((CharSequence)string, (char)'(', (int)0, (boolean)false, (int)6, null);
            Object object = name;
            int n = 0;
            Class<?> clazz2 = clazz;
            String string2 = ((String)object).substring(n, pos);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = string2;
            TypeWrapper[] typeWrapperArray = methodWrapper.getParameterTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeWrapperArray, (String)"methodWrapper.parameterTypes");
            Class<?>[] classArray = this.getClassTypes(typeWrapperArray);
            TypeWrapper typeWrapper = methodWrapper.getReturnType();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeWrapper, (String)"methodWrapper.returnType");
            method2 = TypeUtils.getMethod(clazz2, string3, classArray, this.getClassType(typeWrapper));
            if (method2 == null) {
                throw (Throwable)new IPCException(17, "Method not found: " + name + " in class " + clazz.getName());
            }
            object = methods2;
            String string4 = name;
            Method method3 = method2;
            object.put(string4, method3);
            return method2;
        }
        ConcurrentHashMap<String, Method> concurrentHashMap = methods = mAnnotatedMethods.get(clazz);
        if (concurrentHashMap == null) {
            Intrinsics.throwNpe();
        }
        if ((method = concurrentHashMap.get(name)) != null) {
            TypeUtils.methodMatch(method, methodWrapper);
            return method;
        }
        throw (Throwable)new IPCException(17, "Method not found in class " + clazz.getName() + ". Method id = " + name + ". " + "Please add the same annotation on the corresponding method in the remote process.");
    }

    private TypeCenter() {
    }

    static {
        TypeCenter typeCenter;
        INSTANCE = typeCenter = new TypeCenter();
        mAnnotatedClasses = new ConcurrentHashMap();
        mRawClasses = new ConcurrentHashMap();
        mAnnotatedMethods = new ConcurrentHashMap();
        mRawMethods = new ConcurrentHashMap();
    }
}

