/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.internal;

import android.os.Parcel;
import android.os.Parcelable;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.TypeCenter;
import tv.athena.ipc.wrapper.ParameterWrapper;
import tv.athena.ipc.wrapper.TypeWrapper;

public class Reply
implements Parcelable {
    private static final TypeCenter TYPE_CENTER = TypeCenter.INSTANCE;
    private int mErrorCode;
    private String mErrorMessage;
    private TypeWrapper mClass;
    private String mResult;
    private Long mReturnTimeStamp;
    public static final Parcelable.Creator<Reply> CREATOR = new Parcelable.Creator<Reply>(){

        public Reply createFromParcel(Parcel in) {
            Reply reply = new Reply();
            reply.readFromParcel(in);
            return reply;
        }

        public Reply[] newArray(int size) {
            return new Reply[size];
        }
    };

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mErrorCode);
        parcel.writeString(this.mErrorMessage);
        parcel.writeParcelable((Parcelable)this.mClass, flags);
        parcel.writeString(this.mResult);
        parcel.writeLong(this.mReturnTimeStamp.longValue());
    }

    public void readFromParcel(Parcel in) {
        this.mErrorCode = in.readInt();
        ClassLoader classLoader = Reply.class.getClassLoader();
        this.mErrorMessage = in.readString();
        this.mClass = (TypeWrapper)in.readParcelable(classLoader);
        this.mResult = in.readString();
        this.mReturnTimeStamp = in.readLong();
    }

    private Reply() {
    }

    public Reply(ParameterWrapper parameterWrapper) {
        try {
            Class<?> clazz = TYPE_CENTER.getClassType(parameterWrapper);
            this.mResult = parameterWrapper.getData();
            this.mErrorCode = 0;
            this.mErrorMessage = null;
            this.mClass = new TypeWrapper(clazz);
            this.mReturnTimeStamp = 0L;
        }
        catch (IPCException e) {
            e.printStackTrace();
            this.mErrorCode = e.getErrorCode();
            this.mErrorMessage = e.getMessage();
            this.mResult = null;
            this.mClass = null;
            this.mReturnTimeStamp = 0L;
        }
    }

    public Reply(long mReturnTimeStamp) {
        this.mErrorCode = 0;
        this.mErrorMessage = null;
        this.mResult = null;
        this.mClass = null;
        this.mReturnTimeStamp = mReturnTimeStamp;
    }

    public Reply(int errorCode, String message) {
        this.mErrorCode = errorCode;
        this.mErrorMessage = message;
        this.mResult = null;
        this.mClass = null;
        this.mReturnTimeStamp = 0L;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public boolean success() {
        return this.mErrorCode == 0;
    }

    public String getMessage() {
        return this.mErrorMessage;
    }

    public Object getResult() {
        return this.mResult;
    }

    public String getResultByType() {
        return this.mResult;
    }

    public Long getReturnTimeStamp() {
        return this.mReturnTimeStamp;
    }
}

