/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Pair;
import tv.athena.ipc.api.IPCListener;
import tv.athena.ipc.api.IPCService;
import tv.athena.ipc.internal.CallbackMail;
import tv.athena.ipc.internal.IIPCService;
import tv.athena.ipc.internal.IIPCServiceCallback;
import tv.athena.ipc.internal.Mail;
import tv.athena.ipc.internal.Reply;
import tv.athena.ipc.util.CallbackManager;
import tv.athena.ipc.util.CodeUtils;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.TypeCenter;
import tv.athena.ipc.wrapper.ParameterWrapper;

public class Channel {
    private static final String TAG = "CHANNEL";
    private static volatile Channel sInstance = null;
    private final ConcurrentHashMap<Class<? extends IPCService>, IIPCService> mServices = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends IPCService>, ServiceConnectionWarp> mServiceConnections = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends IPCService>, Boolean> mBindings = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends IPCService>, Boolean> mBounds = new ConcurrentHashMap();
    private ArrayBlockingQueue<IPCListener> mListeners = null;
    private Handler mUiHandler = new Handler(Looper.getMainLooper());
    private static final CallbackManager CALLBACK_MANAGER = CallbackManager.INSTANCE;
    private static final TypeCenter TYPE_CENTER = TypeCenter.INSTANCE;
    private IIPCServiceCallback mServiceCallback = new IIPCServiceCallback.Stub(){

        private Object[] getParameters(ParameterWrapper[] parameterWrappers, Type[] genericReturnType) throws IPCException {
            if (parameterWrappers == null) {
                parameterWrappers = new ParameterWrapper[]{};
            }
            int length = parameterWrappers.length;
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                String data;
                ParameterWrapper parameterWrapper = parameterWrappers[i];
                result[i] = parameterWrapper == null ? null : ((data = parameterWrapper.getData()) == null ? null : CodeUtils.decode(data, genericReturnType[i]));
            }
            return result;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Reply callback(CallbackMail mail) {
            Pair<Boolean, Object> pair = CALLBACK_MANAGER.getCallback(mail.getTimeStamp(), mail.getIndex());
            if (pair == null) {
                return null;
            }
            final Object callback = pair.getSecond();
            if (callback == null) {
                return new Reply(22, "");
            }
            boolean uiThread = (Boolean)pair.getFirst();
            try {
                final Method method = TYPE_CENTER.getMethod(callback.getClass(), mail.getMethod());
                final Object[] parameters = this.getParameters(mail.getParameters(), method.getGenericParameterTypes());
                Object result = null;
                ReflectiveOperationException exception = null;
                if (uiThread) {
                    boolean isMainThread;
                    boolean bl = isMainThread = Looper.getMainLooper() == Looper.myLooper();
                    if (!isMainThread) {
                        Channel.this.mUiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    method.invoke(callback, parameters);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        return null;
                    }
                    try {
                        result = method.invoke(callback, parameters);
                    }
                    catch (IllegalAccessException e) {
                        exception = e;
                    }
                    catch (InvocationTargetException e) {
                        exception = e;
                    }
                } else {
                    try {
                        result = method.invoke(callback, parameters);
                    }
                    catch (IllegalAccessException e) {
                        exception = e;
                    }
                    catch (InvocationTargetException e) {
                        exception = e;
                    }
                }
                if (exception != null) {
                    exception.printStackTrace();
                    throw new IPCException(18, "Error occurs when invoking method " + method + " on " + callback, exception);
                }
                if (result == null) {
                    return null;
                }
                return new Reply(new ParameterWrapper(result));
            }
            catch (IPCException e) {
                e.printStackTrace();
                return new Reply(e.getErrorCode(), e.getMessage());
            }
        }

        @Override
        public void gc(List<Long> timeStamps, List<Integer> indexes) {
            int size = timeStamps.size();
            for (int i = 0; i < size; ++i) {
                CALLBACK_MANAGER.removeCallback(timeStamps.get(i), indexes.get(i));
            }
        }
    };

    private Channel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Channel getInstance() {
        if (sInstance != null) return sInstance;
        Class<Channel> clazz = Channel.class;
        synchronized (Channel.class) {
            if (sInstance != null) return sInstance;
            sInstance = new Channel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Context context, String packageName, Class<? extends IPCService> service) {
        Intent intent;
        ServiceConnectionWarp connection;
        Channel channel = this;
        synchronized (channel) {
            if (this.getBound(service)) {
                return;
            }
            Boolean binding = this.mBindings.get(service);
            if (binding != null && binding.booleanValue()) {
                return;
            }
            this.mBindings.put(service, true);
            connection = new ServiceConnectionWarp(service);
            this.mServiceConnections.put(service, connection);
        }
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            intent = new Intent(context, service);
        } else {
            intent = new Intent();
            intent.setClassName(packageName, service.getName());
        }
        context.bindService(intent, (ServiceConnection)connection, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(Context context, Class<? extends IPCService> service) {
        Channel channel = this;
        synchronized (channel) {
            Boolean bound = this.mBounds.get(service);
            if (bound != null && bound.booleanValue()) {
                ServiceConnectionWarp connection = this.mServiceConnections.get(service);
                if (connection != null) {
                    context.unbindService((ServiceConnection)connection);
                }
                this.mBounds.put(service, false);
            }
        }
    }

    public Reply send(Class<? extends IPCService> service, Mail mail) {
        IIPCService ipcService = this.mServices.get(service);
        try {
            if (ipcService == null) {
                return new Reply(2, "Service Unavailable: Check whether you have connected IPCService.");
            }
            return ipcService.send(mail);
        }
        catch (RemoteException e) {
            return new Reply(1, "Remote Exception: Check whether the process you are communicating with is still alive.");
        }
    }

    public void gc(Class<? extends IPCService> service, List<Long> timeStamps) {
        IIPCService iipcService = this.mServices.get(service);
        if (iipcService == null) {
            Log.e((String)TAG, (String)"Service Unavailable: Check whether you have disconnected the service before a process dies.");
        } else {
            try {
                iipcService.gc(timeStamps);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getBound(Class<? extends IPCService> service) {
        Boolean bound = this.mBounds.get(service);
        return bound != null && bound != false;
    }

    public void addIPCListener(IPCListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayBlockingQueue(50);
        }
        this.mListeners.add(listener);
    }

    public void removeIPCListener(IPCListener listener) {
        if (this.mListeners != null) {
            this.mListeners.remove(listener);
        }
    }

    public boolean isConnected(Class<? extends IPCService> service) {
        IIPCService iipcService = this.mServices.get(service);
        return iipcService != null && iipcService.asBinder().pingBinder();
    }

    private class ServiceConnectionWarp
    implements ServiceConnection {
        private Class<? extends IPCService> mClass;

        ServiceConnectionWarp(Class<? extends IPCService> service) {
            this.mClass = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            Channel channel = Channel.this;
            synchronized (channel) {
                Channel.this.mBounds.put(this.mClass, true);
                Channel.this.mBindings.put(this.mClass, false);
                IIPCService ipcService = IIPCService.Stub.asInterface(service);
                Channel.this.mServices.put(this.mClass, ipcService);
                try {
                    ipcService.register(Channel.this.mServiceCallback, Process.myPid());
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    Log.e((String)Channel.TAG, (String)"Remote Exception: Check whether the process you are communicating with is still alive.");
                    return;
                }
            }
            if (Channel.this.mListeners != null) {
                for (IPCListener listener : Channel.this.mListeners) {
                    listener.onServiceConnected(this.mClass);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName className) {
            Channel channel = Channel.this;
            synchronized (channel) {
                Channel.this.mServices.remove(this.mClass);
                Channel.this.mBounds.put(this.mClass, false);
                Channel.this.mBindings.put(this.mClass, false);
            }
            if (Channel.this.mListeners != null) {
                for (IPCListener listener : Channel.this.mListeners) {
                    listener.onServiceDisconnected(this.mClass);
                }
            }
        }
    }
}

