package tv.athena.amp.core.util

import com.google.gson.Gson
import tv.athena.amp.api.IAmpChannel
import tv.athena.amp.proto.nano.Amp

/**
 * User: wujinsheng1@yy.com
 * Date: 2020/8/19 11:56
 * ModifyTime: 11:56
 * Description:
 */
object AmpParser {
    val gson = Gson()

    fun toMap(pampData: Amp.PRMPData): String {
        val map: HashMap<String, String> = hashMapOf()
        map["resCode"] = "${pampData.resCode}"
        map["resMsg"] = pampData.resMsg
        map["serviceName"] = pampData.serviceName
        map["functionName"] = pampData.functionName
        map["appid"] = "${pampData.appid}"
        if (pampData.serviceName == IAmpChannel.AMP_SERVICE) {
            when (pampData.functionName) {
                IAmpChannel.AMP_FUN_LOAD -> { //这个应该不会出现的
                    val pampLoad = Amp.PAMPLoad.parseFrom(pampData.data)
                    map["data"] = gson.toJson(pampLoad)
                }
                IAmpChannel.AMP_FUN_MGR -> {
                    val pampMgr = Amp.PAMPMgr.parseFrom(pampData.data)
                    val mapInner: HashMap<String, String> = hashMapOf()
                    mapInner["actid"] = pampMgr.actid.toString()
                    mapInner["isShow"] = pampMgr.isShow.toString()
                    mapInner["prio"] = pampMgr.prio.toString()
                    mapInner["ts"] = pampMgr.ts.toString()
                    mapInner["gid"] = pampMgr.gid
                    mapInner["insid"] = pampMgr.insid
                    mapInner["bcid"] = pampMgr.bcid
                    mapInner["bc"] = pampMgr.bc?.contentToString() ?: ""
                    mapInner["bd"] = String(pampMgr.bd)
                    mapInner["urlMap"] = gson.toJson(pampMgr.urlMap)
                    mapInner["extend"] = gson.toJson(pampMgr.extend)
                    map["data"] = mapInner.toString()
                }
                IAmpChannel.AMP_FUN_UPD -> {
                    val pampUpdate = Amp.PAMPUpdate.parseFrom(pampData.data)
                    val mapInner: HashMap<String, String> = hashMapOf()
                    mapInner["actid"] = pampUpdate.actid.toString()
                    mapInner["ts"] = pampUpdate.ts.toString()
                    mapInner["gid"] = pampUpdate.gid
                    mapInner["insid"] = pampUpdate.insid
                    mapInner["bcid"] = pampUpdate.bcid
                    mapInner["bd"] = String(pampUpdate.bd)
                    mapInner["extend"] = gson.toJson(pampUpdate.extend)
                    map["data"] = mapInner.toString()
                }
            }
        }
        return map.toString()
    }
}