package tv.athena.amp.core.log;


import android.util.Log;

import static android.util.Log.DEBUG;
import static android.util.Log.ERROR;
import static android.util.Log.INFO;
import static android.util.Log.WARN;

public class AmpLogger implements AmpLog.Logger {
    private final String module = "amp";

    @Override
    public void log(int lv, String msg) {
        switch (lv) {
            case DEBUG:
                Log.d(module, msg);
                break;
            case INFO:
                Log.i(module, msg);
                break;
            case WARN:
                Log.w(module, msg);
                break;
            case ERROR:
                Log.e(module, msg);
                break;
            default:
                break;
        }
    }
}
