package tv.athena.amp.core

import android.annotation.SuppressLint
import android.content.Context
import com.google.protobuf.nano.MessageNano
import tv.athena.amp.api.AmpConfig
import tv.athena.amp.api.AmpGroupConfig
import tv.athena.amp.api.IAmpChannel
import tv.athena.amp.api.IAmpGroup
import tv.athena.amp.api.IAmpGroupCallback
import tv.athena.amp.api.IAmpSdk
import tv.athena.amp.api.IAmpViewFactory
import tv.athena.amp.core.log.AmpLog
import tv.athena.amp.core.log.AmpLogger
import tv.athena.amp.proto.nano.Amp

/**
 * User: wujinsheng1@yy.com
 * Date: 2020/7/31 11:11
 * ModifyTime: 11:11
 * Description:
 */
@SuppressLint("StaticFieldLeak")
internal object AmpManager : IAmpSdk {
    private var config: AmpConfig? = null
    private var context: Context? = null
    private var dataCenter: AmpDataCenter? = null
    private var insId: Int = 0

    override fun init(context: Context, config: AmpConfig, channel: IAmpChannel) {
        AmpManager.context = context.applicationContext
        AmpManager.config = config
        dataCenter = AmpDataCenter(channel)
        dataCenter?.init()

        if (AmpLog.getLogger() == null) {
            AmpLog.setLogger(AmpLogger())
        }
    }

    override fun create(
            gid: String,
            factory: IAmpViewFactory,
            groupConfig: AmpGroupConfig?,
            param: Amp.PAMPLoad,
            groupCallback: IAmpGroupCallback
    ): IAmpGroup {
        val group = AmpGroup(factory, groupConfig, groupCallback).apply {
            init(gid, "${++insId}", param)
        }
        dataCenter?.apply {
            addAmpGroup(group)
        }
        return group
    }

    override fun getConfig(): AmpConfig? = config

    override fun load(group: IAmpGroup) {
        val req = Amp.PRMPReq().apply {
            this.serviceName = IAmpChannel.AMP_SERVICE
            this.functionName = IAmpChannel.AMP_FUN_LOAD
            this.appid = config?.bizId ?: 0
            this.ticket = config?.ticket?.getToken()
            this.data = MessageNano.toByteArray(group.getLoadParam().apply {
                // 自动补全部分参数
                this.gid = group.getGid()
                this.insid = group.getInsId()
            })
        }
        dataCenter?.apply {
            load(req)
        }
    }

    override fun destroy(group: IAmpGroup) {
        dataCenter?.removeAmpGroup(group)
    }

    override fun destroy() {
        dataCenter?.destroy()
    }
}