package tv.athena.amp.core

import tv.athena.amp.api.AmpGroupConfig
import tv.athena.amp.api.IAmpGroup
import tv.athena.amp.api.IAmpGroupCallback
import tv.athena.amp.api.IAmpView
import tv.athena.amp.api.IAmpViewFactory
import tv.athena.amp.core.log.AmpLog
import tv.athena.amp.core.util.AmpUtil
import tv.athena.amp.proto.nano.Amp

internal class AmpGroup(
    private var mFactory: IAmpViewFactory,
    private var mConfig: AmpGroupConfig?,
    private var mCallback: IAmpGroupCallback? = null
) : IAmpGroup {
    override fun getLoadParam(): Amp.PAMPLoad = mLoadParam
    private var mGid: String = ""
    private var mInsId: String = ""
    private var mBcs: Set<String>? = null
    private var mFullBcs: MutableMap<Int, Set<String>?> = mutableMapOf()
    private var mAmpViews: List<IAmpView>? = null
    private var mLoadParam: Amp.PAMPLoad = Amp.PAMPLoad()

    companion object {
        const val TAG = "AmpGroup"
    }

    override fun init(gid: String, insId: String, loadParam: Amp.PAMPLoad) {
        this.mGid = gid
        this.mInsId = insId
        this.mLoadParam = loadParam
        mCallback?.onInit(this)
        AmpLog.d(TAG, "init group, gid=$gid, insId=$insId")
    }

    override fun getCallback(): IAmpGroupCallback? {
        return mCallback
    }

    override fun getKey(): String {
        return AmpUtil.getAmpGroupKey(mGid, mInsId)
    }

    override fun getGid(): String {
        return mGid
    }

    override fun getInsId(): String {
        return mInsId
    }

    override fun setBcs(bcs: Set<String>?) {
        mBcs = bcs
    }

    override fun getBcs(): Set<String>? {
        return mBcs
    }

    override fun addFullBcs(actId: Int, bcs: Set<String>?) {
        mFullBcs[actId] = bcs
    }

    override fun removeFullBcs(actId: Int) {
        mFullBcs.remove(actId)
    }

    override fun getFullBcs(): Map<Int, Set<String>?> {
        return mFullBcs.toMap()
    }

    override fun getAmpViews(): List<IAmpView>? {
        return mAmpViews
    }

    override fun setAmpViews(views: List<IAmpView>?) {
        mAmpViews = views
    }

    override fun getAmpViewFactory(): IAmpViewFactory {
        return mFactory
    }

    override fun getAmpGroupConfig(): AmpGroupConfig? {
        return mConfig
    }

    override fun destroy() {
        AmpLog.d(TAG, "destroy group, gid=$mGid, insId=$mInsId, bcs=$mBcs, views=${mAmpViews?.size}")
        mAmpViews?.forEach {
            it.destroy()
        }
        mAmpViews?.toMutableSet()?.clear()
        mAmpViews = null

        mCallback?.onDestroy(this)
        mCallback = null
    }
}
