/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.comments.github.lib;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.bjurr.violations.comments.github.lib.GitHubCommentsProvider;
import se.bjurr.violations.comments.lib.CommentsCreator;
import se.bjurr.violations.comments.lib.CommentsProvider;
import se.bjurr.violations.comments.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.util.Utils;

public class ViolationCommentsToGitHubApi {
    public static final String DEFAULT_PROP_VIOLATIONS_OAUTH2TOKEN = "VIOLATIONS_OAUTH2TOKEN";
    public static final String DEFAULT_PROP_VIOLATIONS_USERNAME = "VIOLATIONS_USERNAME";
    public static final String DEFAULT_PROP_VIOLATIONS_PASSWORD = "VIOLATIONS_PASSWORD";
    private String propUsername = "VIOLATIONS_USERNAME";
    private String propPassword = "VIOLATIONS_PASSWORD";
    private String propOAuth2Token = "VIOLATIONS_OAUTH2TOKEN";
    private String gitHubUrl;
    private String oAuth2Token;
    private String username;
    private String password;
    private String repositoryOwner;
    private String repositoryName;
    private int pullRequestId;
    private List<Violation> violations;
    private boolean createSingleFileComments = true;
    private boolean createCommentWithAllSingleFileComments = false;
    private boolean commentOnlyChangedContent = false;
    private boolean keepOldComments = false;
    private String commentTemplate;
    private ViolationsLogger violationsLogger = new ViolationsLogger(){

        public void log(Level level, String string) {
            Logger.getLogger(ViolationCommentsToGitHubApi.class.getSimpleName()).log(level, string);
        }

        public void log(Level level, String string, Throwable t) {
            Logger.getLogger(ViolationCommentsToGitHubApi.class.getSimpleName()).log(level, string, t);
        }
    };
    private Integer maxCommentSize;
    private Integer maxNumberOfViolations;
    private boolean commentOnlyChangedFiles = true;

    public static ViolationCommentsToGitHubApi violationCommentsToGitHubApi() {
        return new ViolationCommentsToGitHubApi();
    }

    private ViolationCommentsToGitHubApi() {
    }

    private void checkState() {
        if (this.oAuth2Token == null && (this.username == null || this.password == null)) {
            throw new IllegalStateException("User and Password, or OAuth2 token, must be set! They can be set with the API or by setting properties.\nUsername/password:\n-DVIOLATIONS_USERNAME=theuser -DVIOLATIONS_PASSWORD=thepassword\nOr OAuth2Token:\n-DVIOLATIONS_OAUTH2TOKEN=123ASDAA...");
        }
        Utils.checkNotNull((Object)this.pullRequestId, (String)"PullRequestId");
        Utils.checkNotNull((Object)this.repositoryName, (String)"RepositoryName");
        Utils.checkNotNull((Object)this.repositoryOwner, (String)"RepositoryOwner");
    }

    public ViolationCommentsToGitHubApi withViolationsLogger(ViolationsLogger violationsLogger) {
        this.violationsLogger = violationsLogger;
        return this;
    }

    public boolean getCommentOnlyChangedContent() {
        return this.commentOnlyChangedContent;
    }

    public boolean getCreateCommentWithAllSingleFileComments() {
        return this.createCommentWithAllSingleFileComments;
    }

    public boolean getCreateSingleFileComments() {
        return this.createSingleFileComments;
    }

    public String getGitHubUrl() {
        if (this.gitHubUrl == null || this.gitHubUrl.trim().isEmpty()) {
            return "https://api.github.com/";
        }
        return this.gitHubUrl;
    }

    public String getOAuth2Token() {
        return this.oAuth2Token;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPropOAuth2Token() {
        return this.propOAuth2Token;
    }

    public String getPropPassword() {
        return this.propPassword;
    }

    public String getPropUsername() {
        return this.propUsername;
    }

    public int getPullRequestId() {
        return this.pullRequestId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryOwner() {
        return this.repositoryOwner;
    }

    public String getUsername() {
        return this.username;
    }

    private void populateFromEnvironmentVariables() {
        if (System.getProperty(this.propUsername) != null) {
            this.username = (String)Utils.firstNonNull((Object)this.username, (Object)System.getProperty(this.propUsername));
        }
        if (System.getProperty(this.propPassword) != null) {
            this.password = (String)Utils.firstNonNull((Object)this.password, (Object)System.getProperty(this.propPassword));
        }
        if (System.getProperty(this.propOAuth2Token) != null) {
            this.oAuth2Token = (String)Utils.firstNonNull((Object)this.oAuth2Token, (Object)System.getProperty(this.propOAuth2Token));
        }
    }

    public void toPullRequest() throws Exception {
        this.populateFromEnvironmentVariables();
        this.checkState();
        GitHubCommentsProvider commentsProvider = new GitHubCommentsProvider(this.violationsLogger, this);
        CommentsCreator.createComments((ViolationsLogger)this.violationsLogger, this.violations, (CommentsProvider)commentsProvider);
    }

    public ViolationCommentsToGitHubApi withCommentOnlyChangedContent(boolean commentOnlyChangedContent) {
        this.commentOnlyChangedContent = commentOnlyChangedContent;
        return this;
    }

    public ViolationCommentsToGitHubApi withCreateCommentWithAllSingleFileComments(boolean createCommentWithAllSingleFileComments) {
        this.createCommentWithAllSingleFileComments = createCommentWithAllSingleFileComments;
        return this;
    }

    public ViolationCommentsToGitHubApi withCreateSingleFileComments(boolean createSingleFileComments) {
        this.createSingleFileComments = createSingleFileComments;
        return this;
    }

    public ViolationCommentsToGitHubApi withCommentOnlyChangedFiles(boolean commentOnlyChangedFiles) {
        this.commentOnlyChangedFiles = commentOnlyChangedFiles;
        return this;
    }

    public boolean getCommentOnlyChangedFiles() {
        return this.commentOnlyChangedFiles;
    }

    public ViolationCommentsToGitHubApi withGitHubUrl(String gitHubUrl) {
        this.gitHubUrl = gitHubUrl;
        return this;
    }

    public ViolationCommentsToGitHubApi withoAuth2Token(String oAuth2Token) {
        this.oAuth2Token = Utils.emptyToNull((String)oAuth2Token);
        return this;
    }

    public ViolationCommentsToGitHubApi withPassword(String password) {
        this.password = password;
        return this;
    }

    public void withPropOAuth2Token(String envOAuth2Token) {
        this.propOAuth2Token = envOAuth2Token;
    }

    public void withPropPassword(String envPassword) {
        this.propPassword = envPassword;
    }

    public void withPropUsername(String envUsername) {
        this.propUsername = envUsername;
    }

    public ViolationCommentsToGitHubApi withPullRequestId(int pullRequestId) {
        this.pullRequestId = pullRequestId;
        return this;
    }

    public ViolationCommentsToGitHubApi withRepositoryName(String repositoryName) {
        this.repositoryName = Utils.emptyToNull((String)repositoryName);
        return this;
    }

    public ViolationCommentsToGitHubApi withRepositoryOwner(String repositoryOwner) {
        this.repositoryOwner = Utils.emptyToNull((String)repositoryOwner);
        return this;
    }

    public ViolationCommentsToGitHubApi withUsername(String username) {
        this.username = username;
        return this;
    }

    public ViolationCommentsToGitHubApi withViolations(List<Violation> violations) {
        this.violations = violations;
        return this;
    }

    public ViolationCommentsToGitHubApi withKeepOldComments(boolean keepOldComments) {
        this.keepOldComments = keepOldComments;
        return this;
    }

    public boolean getKeepOldComments() {
        return this.keepOldComments;
    }

    public ViolationCommentsToGitHubApi withCommentTemplate(String commentTemplate) {
        this.commentTemplate = commentTemplate;
        return this;
    }

    public Optional<String> findCommentTemplate() {
        return Optional.ofNullable(this.commentTemplate);
    }

    public ViolationCommentsToGitHubApi withMaxCommentSize(Integer maxCommentSize) {
        this.maxCommentSize = maxCommentSize;
        return this;
    }

    public ViolationCommentsToGitHubApi withMaxNumberOfViolations(Integer maxNumberOfViolations) {
        this.maxNumberOfViolations = maxNumberOfViolations;
        return this;
    }

    public Integer getMaxNumberOfViolations() {
        return this.maxNumberOfViolations;
    }

    public Integer getMaxCommentSize() {
        return this.maxCommentSize;
    }
}

