/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.comments.github.plugin.gradle;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import se.bjurr.violations.comments.github.lib.ViolationCommentsToGitHubApi;
import se.bjurr.violations.comments.github.plugin.gradle.ViolationCommentsToGitHubPluginExtension;
import se.bjurr.violations.lib.ViolationsApi;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Filtering;

public class ViolationCommentsToGitHubTask
extends DefaultTask {
    private String repositoryOwner;
    private String repositoryName;
    private String pullRequestId;
    private String oAuth2Token;
    private String username;
    private String password;
    private String gitHubUrl;
    private List<List<String>> violations = new ArrayList<List<String>>();
    private boolean createCommentWithAllSingleFileComments = false;
    private boolean createSingleFileComments = true;
    private boolean commentOnlyChangedContent = true;
    private boolean commentOnlyChangedFiles = true;
    private SEVERITY minSeverity;
    private boolean keepOldComments;
    private String commentTemplate;
    private Integer maxNumberOfViolations;

    public void setCommentOnlyChangedFiles(boolean commentOnlyChangedFiles) {
        this.commentOnlyChangedFiles = commentOnlyChangedFiles;
    }

    public void setMaxNumberOfViolations(Integer maxNumberOfViolations) {
        this.maxNumberOfViolations = maxNumberOfViolations;
    }

    public void setKeepOldComments(boolean keepOldComments) {
        this.keepOldComments = keepOldComments;
    }

    public void setCreateCommentWithAllSingleFileComments(boolean createCommentWithAllSingleFileComments) {
        this.createCommentWithAllSingleFileComments = createCommentWithAllSingleFileComments;
    }

    public void setCreateSingleFileComments(boolean createSingleFileComments) {
        this.createSingleFileComments = createSingleFileComments;
    }

    public void setCommentOnlyChangedContent(boolean commentOnlyChangedContent) {
        this.commentOnlyChangedContent = commentOnlyChangedContent;
    }

    public void setGitHubUrl(String gitHubUrl) {
        this.gitHubUrl = gitHubUrl;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setRepositoryOwner(String repositoryOwner) {
        this.repositoryOwner = repositoryOwner;
    }

    public void setPullRequestId(String pullRequestId) {
        this.pullRequestId = pullRequestId;
    }

    public void setViolations(List<List<String>> violations) {
        this.violations = violations;
    }

    public void setoAuth2Token(String oAuth2Token) {
        this.oAuth2Token = oAuth2Token;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setMinSeverity(SEVERITY minSeverity) {
        this.minSeverity = minSeverity;
    }

    public void setCommentTemplate(String commentTemplate) {
        this.commentTemplate = commentTemplate;
    }

    @TaskAction
    public void gitChangelogPluginTasks() throws TaskExecutionException {
        this.getProject().getExtensions().findByType(ViolationCommentsToGitHubPluginExtension.class);
        if (this.pullRequestId == null || this.pullRequestId.equalsIgnoreCase("false")) {
            this.getLogger().info("No pull request id defined, will not send violation comments to GitHub.");
            return;
        }
        Integer pullRequestIdInt = Integer.valueOf(this.pullRequestId);
        if (this.oAuth2Token != null) {
            this.getLogger().info("Using OAuth2Token");
        } else if (this.username != null && this.password != null) {
            this.getLogger().info("Using username/password: " + this.username.substring(0, 1) + ".../*********");
        } else {
            this.getLogger().error("No OAuth2 token and no username/email specified. Will not comment any pull request.");
            return;
        }
        this.getLogger().info("Will comment PR " + this.repositoryOwner + "/" + this.repositoryName + "/" + this.pullRequestId + " on " + this.gitHubUrl);
        List allParsedViolations = new ArrayList();
        for (List<String> configuredViolation : this.violations) {
            String reporter = configuredViolation.size() >= 4 ? configuredViolation.get(3) : null;
            List parsedViolations = ViolationsApi.violationsApi().findAll(Parser.valueOf((String)configuredViolation.get(0))).inFolder(configuredViolation.get(1)).withPattern(configuredViolation.get(2)).withReporter(reporter).violations();
            if (this.minSeverity != null) {
                allParsedViolations = Filtering.withAtLEastSeverity(allParsedViolations, (SEVERITY)this.minSeverity);
            }
            allParsedViolations.addAll(parsedViolations);
        }
        try {
            ViolationCommentsToGitHubApi.violationCommentsToGitHubApi().withoAuth2Token(this.oAuth2Token).withUsername(this.username).withPassword(this.password).withPullRequestId(pullRequestIdInt.intValue()).withRepositoryName(this.repositoryName).withRepositoryOwner(this.repositoryOwner).withGitHubUrl(this.gitHubUrl).withViolations(allParsedViolations).withCreateCommentWithAllSingleFileComments(this.createCommentWithAllSingleFileComments).withCreateSingleFileComments(this.createSingleFileComments).withCommentOnlyChangedContent(this.commentOnlyChangedContent).withCommentOnlyChangedFiles(this.commentOnlyChangedFiles).withKeepOldComments(this.keepOldComments).withCommentTemplate(this.commentTemplate).withMaxNumberOfViolations(this.maxNumberOfViolations).toPullRequest();
        }
        catch (Exception e) {
            this.getLogger().error("", (Throwable)e);
        }
    }
}

