/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.comments.lib;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import se.bjurr.violations.comments.lib.ChangedFileUtils;
import se.bjurr.violations.comments.lib.model.ChangedFile;
import se.bjurr.violations.comments.lib.model.ViolationData;
import se.bjurr.violations.lib.model.Violation;

public class ViolationRenderer {
    private static final String DEFAULT_VIOLATION_TEMPLATE_MUSTACH = "default-violation-template.mustach";

    static List<String> getAccumulatedComments(List<Violation> violations, List<ChangedFile> files, String commentTemplate, Integer maxCommentSize) {
        ArrayList<String> partitions = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("Found " + violations.size() + " violations:\n\n");
        for (Violation violation : violations) {
            ChangedFile changedFile = ChangedFileUtils.findChangedFile(files, violation).orElse(new ChangedFile(violation.getFile(), new ArrayList<String>()));
            String singleFileCommentContent = ViolationRenderer.createSingleFileCommentContent(changedFile, violation, commentTemplate);
            if (maxCommentSize != null && sb.length() + singleFileCommentContent.length() >= maxCommentSize) {
                sb.append(" *<ACCUMULATED-VIOLATIONS>*");
                partitions.add(sb.toString());
                sb = new StringBuilder();
            }
            sb.append(singleFileCommentContent + "\n\n");
        }
        sb.append(" *<ACCUMULATED-VIOLATIONS>*");
        partitions.add(sb.toString());
        return partitions;
    }

    static String createSingleFileCommentContent(ChangedFile changedFile, Violation violation, String commentTemplate) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Reader templateReader = null;
        Optional<String> commentTemplateOpt = Optional.ofNullable(commentTemplate);
        templateReader = commentTemplateOpt.isPresent() && !commentTemplateOpt.get().isEmpty() ? new StringReader(commentTemplateOpt.get()) : mf.getReader(DEFAULT_VIOLATION_TEMPLATE_MUSTACH);
        Mustache mustache = mf.compile(templateReader, "Violation Template");
        StringWriter writer = new StringWriter();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("violation", (Object)new ViolationData(violation));
        context.put("changedFile", changedFile);
        ArrayList<HashMap<String, Object>> scopes = new ArrayList<HashMap<String, Object>>();
        scopes.add(context);
        mustache.execute((Writer)writer, scopes);
        return ((Object)writer).toString() + "\n*" + "<this is a auto generated comment from violation-comments-lib F7F8ASD8123FSDF>" + "* *<" + ViolationRenderer.identifier(violation) + ">*";
    }

    static String identifier(Violation violation) {
        return "a" + violation.toString().replaceAll("[^a-zA-Z0-9]", "").hashCode();
    }
}

