/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.comments.lib;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatchParser {
    private static final Pattern RANGE_PATTERN = Pattern.compile("@@\\p{IsWhite_Space}-[0-9]+(?:,[0-9]+)?\\p{IsWhite_Space}\\+([0-9]+)(?:,[0-9]+)?\\p{IsWhite_Space}@@.*");
    private final Map<Integer, Optional<Integer>> newLineToOldLineTable = new TreeMap<Integer, Optional<Integer>>();
    private final Map<Integer, Optional<Integer>> newLineToLineInDiffTable = new TreeMap<Integer, Optional<Integer>>();

    public PatchParser(String patchString) {
        if (patchString == null) {
            return;
        }
        int currentLine = -1;
        int patchLocation = 1;
        int diffLocation = 0;
        for (String line : patchString.split("\n")) {
            if (line.startsWith("@")) {
                Matcher matcher = RANGE_PATTERN.matcher(line);
                if (!matcher.matches()) {
                    throw new IllegalStateException("Unable to parse patch line " + line + "\nFull patch: \n" + patchString);
                }
                patchLocation = currentLine = Integer.parseInt(matcher.group(1));
            } else if (line.startsWith("+") && !line.startsWith("++")) {
                this.newLineToOldLineTable.put(currentLine, Optional.empty());
                ++currentLine;
            } else if (line.startsWith(" ")) {
                this.newLineToOldLineTable.put(currentLine, Optional.of(patchLocation));
                ++currentLine;
                ++patchLocation;
            } else {
                ++patchLocation;
            }
            this.newLineToLineInDiffTable.put(currentLine, Optional.of(++diffLocation));
        }
    }

    public boolean isLineInDiff(Integer newLine) {
        return this.newLineToLineInDiffTable.containsKey(newLine);
    }

    public Optional<Integer> findOldLine(Integer newLine) {
        if (this.newLineToOldLineTable.containsKey(newLine)) {
            return this.newLineToOldLineTable.get(newLine);
        }
        return Optional.empty();
    }

    public Optional<Integer> findLineInDiff(int newLine) {
        if (this.newLineToLineInDiffTable.containsKey(newLine)) {
            return this.newLineToLineInDiffTable.get(newLine);
        }
        return Optional.empty();
    }

    Map<Integer, Optional<Integer>> getNewLineToOldLineTable() {
        return this.newLineToOldLineTable;
    }
}

