/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.comments.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.stream.Collectors;
import se.bjurr.violations.comments.lib.ChangedFileUtils;
import se.bjurr.violations.comments.lib.CommentFilterer;
import se.bjurr.violations.comments.lib.CommentsProvider;
import se.bjurr.violations.comments.lib.ViolationComments;
import se.bjurr.violations.comments.lib.ViolationRenderer;
import se.bjurr.violations.comments.lib.ViolationsLogger;
import se.bjurr.violations.comments.lib.model.ChangedFile;
import se.bjurr.violations.comments.lib.model.Comment;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.util.Utils;

public class CommentsCreator {
    public static final String FINGERPRINT = "<this is a auto generated comment from violation-comments-lib F7F8ASD8123FSDF>";
    public static final String FINGERPRINT_ACC = "<ACCUMULATED-VIOLATIONS>";
    private final ViolationsLogger violationsLogger;
    private final CommentsProvider commentsProvider;
    private final List<ChangedFile> files;
    private final List<Violation> violations;

    public static void createComments(ViolationsLogger violationsLogger, List<Violation> violations, CommentsProvider commentsProvider) {
        CommentsCreator commentsCreator = new CommentsCreator(violationsLogger, commentsProvider, violations);
        commentsCreator.createComments();
    }

    CommentsCreator(ViolationsLogger violationsLogger, CommentsProvider commentsProvider, List<Violation> violations) {
        Utils.checkNotNull(violations, (String)"violations");
        Utils.checkNotNull((Object)commentsProvider, (String)"commentsProvider");
        this.violationsLogger = (ViolationsLogger)Utils.checkNotNull((Object)violationsLogger, (String)"violationsLogger");
        this.commentsProvider = commentsProvider;
        this.files = commentsProvider.getFiles();
        List<Violation> allViolations = violations;
        if (commentsProvider.shouldCommentOnlyChangedFiles()) {
            allViolations = this.filterChanged(this.files, violations);
        }
        this.violations = commentsProvider.getMaxNumberOfViolations() != null && allViolations.size() > commentsProvider.getMaxNumberOfViolations() ? allViolations.subList(0, commentsProvider.getMaxNumberOfViolations()) : allViolations;
    }

    public void createComments() {
        if (this.commentsProvider.shouldCreateCommentWithAllSingleFileComments()) {
            this.createCommentWithAllSingleFileComments();
        }
        if (this.commentsProvider.shouldCreateSingleFileComment()) {
            if (!this.commentsProvider.shouldCommentOnlyChangedFiles()) {
                throw new IllegalStateException("Cannot comment single files when having commentOnlyChangedFiles set to false");
            }
            this.createSingleFileComments();
        }
        if (!this.commentsProvider.shouldCreateCommentWithAllSingleFileComments() && !this.commentsProvider.shouldCreateSingleFileComment()) {
            this.violationsLogger.log(Level.INFO, "Will not comment because both 'CreateCommentWithAllSingleFileComments' and 'CreateSingleFileComment' is false.");
        }
    }

    private void createCommentWithAllSingleFileComments() {
        List<String> accumulatedComments = ViolationRenderer.getAccumulatedComments(this.violations, this.files, this.commentsProvider.findCommentTemplate().orElse(null), this.commentsProvider.getMaxCommentSize());
        for (String accumulatedComment : accumulatedComments) {
            this.violationsLogger.log(Level.INFO, "Asking " + this.commentsProvider.getClass().getSimpleName() + " to create comment with all single file comments.");
            List<Comment> oldComments = this.commentsProvider.getComments();
            oldComments = CommentFilterer.filterCommentsWithContent(oldComments, FINGERPRINT_ACC);
            List<Comment> alreadyMadeComments = CommentFilterer.filterCommentsWithContent(oldComments, accumulatedComment);
            this.removeOldCommentsThatAreNotStillReported(oldComments, alreadyMadeComments);
            if (this.violations.isEmpty()) {
                return;
            }
            boolean commentHasNotBeenMade = alreadyMadeComments.isEmpty();
            if (!commentHasNotBeenMade) continue;
            this.commentsProvider.createComment(accumulatedComment);
        }
    }

    private void createSingleFileComments() {
        List<Comment> oldComments = this.commentsProvider.getComments();
        oldComments = CommentFilterer.filterCommentsWithContent(oldComments, FINGERPRINT);
        oldComments = CommentFilterer.filterCommentsWithoutContent(oldComments, FINGERPRINT_ACC);
        this.violationsLogger.log(Level.INFO, "Asking " + this.commentsProvider.getClass().getSimpleName() + " to comment:");
        ViolationComments alreadyMadeComments = CommentFilterer.getViolationComments(oldComments, this.violations);
        this.removeOldCommentsThatAreNotStillReported(oldComments, alreadyMadeComments.getComments());
        for (Violation violation : this.violations) {
            Optional<ChangedFile> changedFile;
            boolean violationCommentExistsSinceBefore = alreadyMadeComments.getViolations().contains(violation);
            if (violationCommentExistsSinceBefore || !(changedFile = ChangedFileUtils.findChangedFile(this.files, violation)).isPresent()) continue;
            String commentTemplate = this.commentsProvider.findCommentTemplate().orElse(null);
            String singleFileCommentContent = ViolationRenderer.createSingleFileCommentContent(changedFile.get(), violation, commentTemplate);
            this.violationsLogger.log(Level.INFO, violation.getReporter() + " " + violation.getSeverity() + " " + violation.getRule() + " " + changedFile.get().getFilename() + " " + violation.getStartLine() + " " + violation.getSource());
            this.commentsProvider.createSingleFileComment(changedFile.get(), violation.getStartLine(), singleFileCommentContent);
        }
    }

    private void removeOldCommentsThatAreNotStillReported(List<Comment> oldComments, List<Comment> comments) {
        if (!this.commentsProvider.shouldKeepOldComments()) {
            ArrayList<Comment> existingWithoutViolation = new ArrayList<Comment>();
            existingWithoutViolation.addAll(oldComments);
            existingWithoutViolation.removeAll(comments);
            this.commentsProvider.removeComments(existingWithoutViolation);
        }
    }

    private List<Violation> filterChanged(List<ChangedFile> files, List<Violation> mixedViolations) {
        String changedFiles = files.stream().map(f -> f.getFilename()).sorted().collect(Collectors.joining("\n  "));
        this.violationsLogger.log(Level.INFO, "Files changed:\n  " + changedFiles);
        String violationFiles = mixedViolations.stream().map(f -> f.getFile()).distinct().sorted().collect(Collectors.joining("\n  "));
        this.violationsLogger.log(Level.INFO, "Files with violations:\n  " + violationFiles);
        ArrayList<Violation> isChanged = new ArrayList<Violation>();
        TreeSet<String> included = new TreeSet<String>();
        TreeSet<String> notIncludedUntouched = new TreeSet<String>();
        TreeSet<String> notIncludedNotChanged = new TreeSet<String>();
        for (Violation violation : mixedViolations) {
            Optional<ChangedFile> file = ChangedFileUtils.findChangedFile(files, violation);
            String violationFile = violation.getFile() + " " + violation.getStartLine();
            if (file.isPresent()) {
                boolean shouldComment = this.commentsProvider.shouldComment(file.get(), violation.getStartLine());
                if (shouldComment) {
                    isChanged.add(violation);
                    included.add(violationFile);
                    continue;
                }
                notIncludedUntouched.add(violationFile);
                continue;
            }
            notIncludedNotChanged.add(violationFile);
        }
        if (!included.isEmpty()) {
            this.violationsLogger.log(Level.INFO, "Will include violations on:\n  " + included.stream().collect(Collectors.joining("\n  ")));
        }
        if (!notIncludedUntouched.isEmpty()) {
            this.violationsLogger.log(Level.INFO, "Will not include violations on changed files because violation reported on untouched lines:\n  " + notIncludedUntouched.stream().collect(Collectors.joining("\n  ")));
        }
        if (!notIncludedNotChanged.isEmpty()) {
            this.violationsLogger.log(Level.INFO, "Will not include violations on unchanged files:\n  " + notIncludedNotChanged.stream().collect(Collectors.joining("\n  ")));
        }
        return isChanged;
    }
}

