/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.comments.lib;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.comments.lib.ViolationComments;
import se.bjurr.violations.comments.lib.ViolationRenderer;
import se.bjurr.violations.comments.lib.model.Comment;
import se.bjurr.violations.lib.model.Violation;

public class CommentFilterer {
    static List<Comment> filterCommentsWithContent(List<Comment> unfilteredComments, String containing) {
        ArrayList<Comment> filteredComments = new ArrayList<Comment>();
        for (Comment comment : unfilteredComments) {
            if (!comment.getContent().trim().contains(containing.trim())) continue;
            filteredComments.add(comment);
        }
        return filteredComments;
    }

    static List<Comment> filterCommentsWithoutContent(List<Comment> unfilteredComments, String containing) {
        ArrayList<Comment> filteredComments = new ArrayList<Comment>();
        for (Comment comment : unfilteredComments) {
            if (comment.getContent().trim().contains(containing.trim())) continue;
            filteredComments.add(comment);
        }
        return filteredComments;
    }

    static ViolationComments getViolationComments(List<Comment> comments, List<Violation> violations) {
        ArrayList<Violation> madeViolations = new ArrayList<Violation>();
        ArrayList<Comment> madeComments = new ArrayList<Comment>();
        for (Violation violation : violations) {
            for (Comment candidate : comments) {
                boolean containsIdentifier = candidate.getContent().contains(ViolationRenderer.identifier(violation) + "");
                if (!containsIdentifier) continue;
                madeViolations.add(violation);
                madeComments.add(candidate);
            }
        }
        return new ViolationComments(madeComments, madeViolations);
    }
}

