/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.tuweni.bytes.Bytes;
import org.web3j.crypto.Blob;
import org.web3j.crypto.BlobUtils;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.crypto.transaction.type.Transaction1559;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class Transaction4844
extends Transaction1559
implements ITransaction {
    private final BigInteger maxFeePerBlobGas;
    private final List<Bytes> versionedHashes;
    private final Optional<List<Blob>> blobs;
    private final Optional<List<Bytes>> kzgProofs;
    private final Optional<List<Bytes>> kzgCommitments;

    protected Transaction4844(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxFeePerBlobGas, List<Bytes> versionedHashes) {
        super(chainId, nonce, gasLimit, to, value, data, maxPriorityFeePerGas, maxFeePerGas);
        this.maxFeePerBlobGas = maxFeePerBlobGas;
        this.versionedHashes = versionedHashes;
        this.blobs = Optional.empty();
        this.kzgCommitments = Optional.empty();
        this.kzgProofs = Optional.empty();
    }

    protected Transaction4844(List<Blob> blobs, List<Bytes> kzgCommitments, List<Bytes> kzgProofs, long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxFeePerBlobGas, List<Bytes> versionedHashes) {
        super(chainId, nonce, gasLimit, to, value, data, maxPriorityFeePerGas, maxFeePerGas);
        this.maxFeePerBlobGas = maxFeePerBlobGas;
        this.versionedHashes = versionedHashes;
        this.blobs = Optional.ofNullable(blobs);
        this.kzgCommitments = Optional.ofNullable(kzgCommitments);
        this.kzgProofs = Optional.ofNullable(kzgProofs);
    }

    protected Transaction4844(List<Blob> blobsData, long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxFeePerBlobGas) {
        super(chainId, nonce, gasLimit, to, value, data, maxPriorityFeePerGas, maxFeePerGas);
        this.maxFeePerBlobGas = maxFeePerBlobGas;
        this.blobs = Optional.ofNullable(blobsData);
        assert (blobsData != null);
        this.kzgCommitments = Optional.of(blobsData.stream().map(BlobUtils::getCommitment).collect(Collectors.toList()));
        this.kzgProofs = Optional.of(IntStream.range(0, blobsData.size()).mapToObj(i -> BlobUtils.getProof((Blob)blobsData.get(i), this.kzgCommitments.get().get(i))).collect(Collectors.toList()));
        this.versionedHashes = this.kzgCommitments.get().stream().map(BlobUtils::kzgToVersionedHash).collect(Collectors.toList());
    }

    @Override
    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        ArrayList<Object> resultTx = new ArrayList<Object>();
        resultTx.add(RlpString.create((long)this.getChainId()));
        resultTx.add(RlpString.create((BigInteger)this.getNonce()));
        resultTx.add(RlpString.create((BigInteger)this.getMaxPriorityFeePerGas()));
        resultTx.add(RlpString.create((BigInteger)this.getMaxFeePerGas()));
        resultTx.add(RlpString.create((BigInteger)this.getGasLimit()));
        String to = this.getTo();
        if (to != null && to.length() > 0) {
            resultTx.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)to)));
        } else {
            resultTx.add(RlpString.create((String)""));
        }
        resultTx.add(RlpString.create((BigInteger)this.getValue()));
        byte[] data = Numeric.hexStringToByteArray((String)this.getData());
        resultTx.add(RlpString.create((byte[])data));
        resultTx.add(new RlpList(new RlpType[0]));
        resultTx.add(RlpString.create((BigInteger)this.getMaxFeePerBlobGas()));
        resultTx.add(new RlpList(this.getRlpVersionedHashes()));
        if (signatureData != null) {
            resultTx.add(RlpString.create((long)Sign.getRecId(signatureData, this.getChainId())));
            resultTx.add(RlpString.create((byte[])org.web3j.utils.Bytes.trimLeadingZeroes((byte[])signatureData.getR())));
            resultTx.add(RlpString.create((byte[])org.web3j.utils.Bytes.trimLeadingZeroes((byte[])signatureData.getS())));
        }
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)new RlpList(resultTx));
        result.add((RlpType)new RlpList(this.getRlpBlobs()));
        result.add((RlpType)new RlpList(this.getRlpKzgCommitments()));
        result.add((RlpType)new RlpList(this.getRlpKzgProofs()));
        return result;
    }

    public static Transaction4844 createTransaction(List<Blob> blobs, List<Bytes> kzgCommitments, List<Bytes> kzgProofs, long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxFeePerBlobGas, List<Bytes> versionedHashes) {
        return new Transaction4844(blobs, kzgCommitments, kzgProofs, chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, value, data, maxFeePerBlobGas, versionedHashes);
    }

    public static Transaction4844 createTransaction(List<Blob> blobs, long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxFeePerBlobGas) {
        return new Transaction4844(blobs, chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, value, data, maxFeePerBlobGas);
    }

    public static Transaction4844 createTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxFeePerBlobGas, List<Bytes> versionedHashes) {
        return new Transaction4844(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, value, data, maxFeePerBlobGas, versionedHashes);
    }

    public BigInteger getMaxFeePerBlobGas() {
        return this.maxFeePerBlobGas;
    }

    public Optional<List<Blob>> getBlobs() {
        return this.blobs;
    }

    public Optional<List<Bytes>> getKzgCommitments() {
        return this.kzgCommitments;
    }

    public Optional<List<Bytes>> getKzgProofs() {
        return this.kzgProofs;
    }

    public List<Bytes> getVersionedHashes() {
        return this.versionedHashes;
    }

    public List<RlpType> getRlpVersionedHashes() {
        return this.versionedHashes.stream().map(hash -> RlpString.create((byte[])hash.toArray())).collect(Collectors.toList());
    }

    public List<RlpType> getRlpKzgCommitments() {
        return this.kzgCommitments.map(bytesList -> bytesList.stream().map(bytes -> RlpString.create((byte[])bytes.toArray())).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public List<RlpType> getRlpKzgProofs() {
        return this.kzgProofs.map(bytesList -> bytesList.stream().map(bytes -> RlpString.create((byte[])bytes.toArray())).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public List<RlpType> getRlpBlobs() {
        return this.blobs.map(blobList -> blobList.stream().map(blob -> RlpString.create((byte[])blob.getData().toArray())).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public TransactionType getType() {
        return TransactionType.EIP4844;
    }
}

