/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigInteger;
import org.web3j.utils.Numeric;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserOperationStruct {
    private String sender;
    private BigInteger nonce;
    private String initCode;
    private String callData;
    private String callGasLimit;
    private String verificationGasLimit;
    private String preVerificationGas;
    private String maxFeePerGas;
    private String maxPriorityFeePerGas;
    private String signature;
    private String paymasterAndData;

    public UserOperationStruct(String sender, BigInteger nonce, String initCode, String callData, String callGasLimit, String verificationGasLimit, String preVerificationGas, String maxFeePerGas, String maxPriorityFeePerGas, String signature, String paymasterAndData) {
        this.sender = sender;
        this.nonce = nonce;
        this.initCode = initCode;
        this.callData = callData;
        this.callGasLimit = callGasLimit;
        this.verificationGasLimit = verificationGasLimit;
        this.preVerificationGas = preVerificationGas;
        this.maxFeePerGas = maxFeePerGas;
        this.maxPriorityFeePerGas = maxPriorityFeePerGas;
        this.signature = signature;
        this.paymasterAndData = paymasterAndData;
    }

    public static UserOperationStruct createEthSendUserOperationTransaction(String sender, BigInteger nonce, String initCode, String callData, String callGasLimit, String verificationGasLimit, String preVerificationGas, String maxFeePerGas, String maxPriorityFeePerGas, String signature, String paymasterAndData) {
        return new UserOperationStruct(sender, nonce, initCode, callData, callGasLimit, verificationGasLimit, preVerificationGas, maxFeePerGas, maxPriorityFeePerGas, signature, paymasterAndData);
    }

    public static UserOperationStruct createEthEstimateUserOperationGasTransaction(String sender, BigInteger nonce, String initCode, String callData, String callGasLimit, String verificationGasLimit, String preVerificationGas, String maxFeePerGas, String maxPriorityFeePerGas, String signature, String paymasterAndData) {
        return UserOperationStruct.createEthSendUserOperationTransaction(sender, nonce, initCode, callData, callGasLimit, verificationGasLimit, preVerificationGas, maxFeePerGas, maxPriorityFeePerGas, signature, paymasterAndData);
    }

    public String getSender() {
        return this.sender;
    }

    public String getCallData() {
        return this.callData;
    }

    public String getNonce() {
        if (this.nonce != null) {
            return Numeric.encodeQuantity((BigInteger)this.nonce);
        }
        return null;
    }

    public String getInitCode() {
        return this.initCode;
    }

    public String getCallGasLimit() {
        return this.callGasLimit;
    }

    public String getVerificationGasLimit() {
        return this.verificationGasLimit;
    }

    public String getPreVerificationGas() {
        return this.preVerificationGas;
    }

    public String getMaxFeePerGas() {
        return this.maxFeePerGas;
    }

    public String getMaxPriorityFeePerGas() {
        return this.maxPriorityFeePerGas;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getPaymasterAndData() {
        return this.paymasterAndData;
    }
}

