/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.filters.Callback;
import org.web3j.protocol.core.filters.Filter;
import org.web3j.protocol.core.filters.FilterException;
import org.web3j.protocol.core.methods.response.EthFilter;
import org.web3j.protocol.core.methods.response.EthLog;

public class BlocksFilter
extends Filter<List<String>> {
    public BlocksFilter(Web3j web3j, Callback<List<String>> callback) {
        super(web3j, callback);
    }

    @Override
    protected EthFilter sendRequest() throws IOException {
        return this.web3j.ethNewBlockFilter().send();
    }

    @Override
    protected void process(List<EthLog.LogResult> logResults) {
        ArrayList<String> blockHashes = new ArrayList<String>(logResults.size());
        for (EthLog.LogResult logResult : logResults) {
            if (!(logResult instanceof EthLog.Hash)) {
                throw new FilterException("Unexpected result type: " + String.valueOf(logResult.get()) + ", required Hash");
            }
            blockHashes.add(((EthLog.Hash)logResult).get());
        }
        this.callback.onEvent(blockHashes);
    }

    @Override
    protected Optional<Request<?, EthLog>> getFilterLogs(BigInteger filterId) {
        return Optional.empty();
    }
}

