/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

public class FilteredFile {
    private String openToken = "[[";
    private String closeToken = "]]";
    private List<String> lines = new ArrayList<String>();

    public FilteredFile(InputStream in, VariableResolver resolver) throws IOException {
        this.parse(in, resolver);
    }

    public void setOpenToken(String token) {
        this.openToken = token;
    }

    public void setCloseToken(String token) {
        this.closeToken = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream in, VariableResolver resolver) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                if (resolver != null) {
                    this.lines.add(Utils.replaceVariables(resolver, line, this.openToken, this.closeToken));
                    continue;
                }
                this.lines.add(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String line : this.lines) {
            builder.append(line).append('\n');
        }
        return builder.toString();
    }
}

