/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Choreographer;
import android.view.IWindowFocusObserver;
import android.view.IWindowId;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.WindowId;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.ImageView;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowCanvas;
import org.robolectric.shadows.ShadowChoreographer;
import org.robolectric.shadows.ShadowDisplay;
import org.robolectric.shadows.ShadowLegacyLooper;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=View.class)
@SuppressLint(value={"NewApi"})
public class ShadowView {
    @RealObject
    protected View realView;
    private static final List<View.OnClickListener> globalClickListeners = new CopyOnWriteArrayList<View.OnClickListener>();
    private static final List<View.OnLongClickListener> globalLongClickListeners = new CopyOnWriteArrayList<View.OnLongClickListener>();
    private View.OnClickListener onClickListener;
    private View.OnLongClickListener onLongClickListener;
    private View.OnFocusChangeListener onFocusChangeListener;
    private View.OnSystemUiVisibilityChangeListener onSystemUiVisibilityChangeListener;
    private final HashSet<View.OnAttachStateChangeListener> onAttachStateChangeListeners = new HashSet();
    private boolean wasInvalidated;
    private View.OnTouchListener onTouchListener;
    protected AttributeSet attributeSet;
    public Point scrollToCoordinates = new Point();
    private boolean didRequestLayout;
    private MotionEvent lastTouchEvent;
    private int hapticFeedbackPerformed = -1;
    private boolean onLayoutWasCalled;
    private View.OnCreateContextMenuListener onCreateContextMenuListener;
    private Rect globalVisibleRect;
    private int layerType;
    private AnimationRunner animationRunner;

    @Deprecated
    public static boolean clickOn(View view) {
        ShadowView shadowView = (ShadowView)Shadow.extract((Object)view);
        return shadowView.checkedPerformClick();
    }

    public static String visualize(View view) {
        Canvas canvas = new Canvas();
        view.draw(canvas);
        ShadowCanvas shadowCanvas = (ShadowCanvas)Shadow.extract((Object)canvas);
        return shadowCanvas.getDescription();
    }

    @Deprecated
    public static void dump(View view) {
        ShadowView shadowView = (ShadowView)Shadow.extract((Object)view);
        shadowView.dump();
    }

    public static String innerText(View view) {
        ShadowView shadowView = (ShadowView)Shadow.extract((Object)view);
        return shadowView.innerText();
    }

    @Implementation
    protected void __constructor__(Context context, AttributeSet attributeSet, int defStyle) {
        if (context == null) {
            throw new NullPointerException("no context");
        }
        this.attributeSet = attributeSet;
        Shadow.invokeConstructor(View.class, (Object)this.realView, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(AttributeSet.class, (Object)attributeSet), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)defStyle)});
    }

    @Implementation
    protected void setLayerType(int layerType, Paint paint) {
        this.layerType = layerType;
    }

    @Implementation
    protected void setOnFocusChangeListener(View.OnFocusChangeListener l) {
        this.onFocusChangeListener = l;
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).setOnFocusChangeListener(l);
    }

    @Implementation
    protected void setOnClickListener(View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).setOnClickListener(onClickListener);
    }

    @Implementation
    protected void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.onLongClickListener = onLongClickListener;
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).setOnLongClickListener(onLongClickListener);
    }

    @Implementation
    protected void setOnSystemUiVisibilityChangeListener(View.OnSystemUiVisibilityChangeListener onSystemUiVisibilityChangeListener) {
        this.onSystemUiVisibilityChangeListener = onSystemUiVisibilityChangeListener;
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).setOnSystemUiVisibilityChangeListener(onSystemUiVisibilityChangeListener);
    }

    @Implementation
    protected void setOnCreateContextMenuListener(View.OnCreateContextMenuListener onCreateContextMenuListener) {
        this.onCreateContextMenuListener = onCreateContextMenuListener;
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).setOnCreateContextMenuListener(onCreateContextMenuListener);
    }

    @Implementation
    protected void addOnAttachStateChangeListener(View.OnAttachStateChangeListener onAttachStateChangeListener) {
        this.onAttachStateChangeListeners.add(onAttachStateChangeListener);
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).addOnAttachStateChangeListener(onAttachStateChangeListener);
    }

    @Implementation
    protected void removeOnAttachStateChangeListener(View.OnAttachStateChangeListener onAttachStateChangeListener) {
        this.onAttachStateChangeListeners.remove(onAttachStateChangeListener);
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).removeOnAttachStateChangeListener(onAttachStateChangeListener);
    }

    @Implementation
    protected void draw(Canvas canvas) {
        Drawable drawable2;
        Drawable background = this.realView.getBackground();
        if (background != null) {
            ShadowCanvas shadowCanvas = (ShadowCanvas)Shadow.extract((Object)canvas);
            shadowCanvas.appendDescription("background:");
            background.draw(canvas);
        }
        if (this.realView instanceof ImageView && (drawable2 = ((ImageView)this.realView).getDrawable()) != null) {
            drawable2.draw(canvas);
        }
    }

    @Implementation
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.onLayoutWasCalled = true;
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).onLayout(changed, left, top, right, bottom);
    }

    public boolean onLayoutWasCalled() {
        return this.onLayoutWasCalled;
    }

    @Implementation
    protected void requestLayout() {
        this.didRequestLayout = true;
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).requestLayout();
    }

    @Implementation
    protected boolean performClick() {
        for (View.OnClickListener listener : globalClickListeners) {
            listener.onClick(this.realView);
        }
        return ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).performClick();
    }

    public static void addGlobalPerformClickListener(View.OnClickListener listener) {
        globalClickListeners.add(listener);
    }

    public static void removeGlobalPerformClickListener(View.OnClickListener listener) {
        globalClickListeners.remove(listener);
    }

    @Implementation
    protected boolean performLongClick() {
        for (View.OnLongClickListener listener : globalLongClickListeners) {
            listener.onLongClick(this.realView);
        }
        return ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).performLongClick();
    }

    public static void addGlobalPerformLongClickListener(View.OnLongClickListener listener) {
        globalLongClickListeners.add(listener);
    }

    public static void removeGlobalPerformLongClickListener(View.OnLongClickListener listener) {
        globalLongClickListeners.remove(listener);
    }

    @Resetter
    public static void reset() {
        globalClickListeners.clear();
        globalLongClickListeners.clear();
    }

    public boolean didRequestLayout() {
        return this.didRequestLayout;
    }

    public void setDidRequestLayout(boolean didRequestLayout) {
        this.didRequestLayout = didRequestLayout;
    }

    public void setViewFocus(boolean hasFocus) {
        if (this.onFocusChangeListener != null) {
            this.onFocusChangeListener.onFocusChange(this.realView, hasFocus);
        }
    }

    @Implementation
    protected void invalidate() {
        this.wasInvalidated = true;
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).invalidate();
    }

    @Implementation
    protected boolean onTouchEvent(MotionEvent event) {
        this.lastTouchEvent = event;
        return ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).onTouchEvent(event);
    }

    @Implementation
    protected void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.onTouchListener = onTouchListener;
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).setOnTouchListener(onTouchListener);
    }

    public MotionEvent getLastTouchEvent() {
        return this.lastTouchEvent;
    }

    public String innerText() {
        return "";
    }

    @Deprecated
    public void dump() {
        this.dump(System.out, 0);
    }

    @Deprecated
    public void dump(PrintStream out, int indent) {
        this.dumpFirstPart(out, indent);
        out.println("/>");
    }

    @Deprecated
    protected void dumpFirstPart(PrintStream out, int indent) {
        this.dumpIndent(out, indent);
        String string2 = String.valueOf(this.realView.getClass().getSimpleName());
        out.print(string2.length() != 0 ? "<".concat(string2) : new String("<"));
        this.dumpAttributes(out);
    }

    @Deprecated
    protected void dumpAttributes(PrintStream out) {
        if (this.realView.getId() > 0) {
            this.dumpAttribute(out, "id", this.realView.getContext().getResources().getResourceName(this.realView.getId()));
        }
        switch (this.realView.getVisibility()) {
            case 0: {
                break;
            }
            case 4: {
                this.dumpAttribute(out, "visibility", "INVISIBLE");
                break;
            }
            case 8: {
                this.dumpAttribute(out, "visibility", "GONE");
            }
        }
    }

    @Deprecated
    protected void dumpAttribute(PrintStream out, String name, String value) {
        String string2 = value == null ? null : TextUtils.htmlEncode((String)value);
        out.print(new StringBuilder(4 + String.valueOf(name).length() + String.valueOf(string2).length()).append(" ").append(name).append("=\"").append(string2).append("\"").toString());
    }

    @Deprecated
    protected void dumpIndent(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(" ");
        }
    }

    public boolean wasInvalidated() {
        return this.wasInvalidated;
    }

    public void clearWasInvalidated() {
        this.wasInvalidated = false;
    }

    @Deprecated
    public boolean checkedPerformClick() {
        if (!this.realView.isShown()) {
            throw new RuntimeException("View is not visible and cannot be clicked");
        }
        if (!this.realView.isEnabled()) {
            throw new RuntimeException("View is not enabled and cannot be clicked");
        }
        boolean res = this.realView.performClick();
        ShadowLooper.shadowMainLooper().idleIfPaused();
        return res;
    }

    public View.OnTouchListener getOnTouchListener() {
        return this.onTouchListener;
    }

    public View.OnClickListener getOnClickListener() {
        return this.onClickListener;
    }

    public View.OnLongClickListener getOnLongClickListener() {
        return this.onLongClickListener;
    }

    public View.OnSystemUiVisibilityChangeListener getOnSystemUiVisibilityChangeListener() {
        return this.onSystemUiVisibilityChangeListener;
    }

    public View.OnCreateContextMenuListener getOnCreateContextMenuListener() {
        return this.onCreateContextMenuListener;
    }

    public Set<View.OnAttachStateChangeListener> getOnAttachStateChangeListeners() {
        return this.onAttachStateChangeListeners;
    }

    @Implementation
    protected boolean post(Runnable action) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.PAUSED) {
            return ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).post(action);
        }
        ShadowApplication.getInstance().getForegroundThreadScheduler().post(action);
        return true;
    }

    @Implementation
    protected boolean postDelayed(Runnable action, long delayMills) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.PAUSED) {
            return ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).postDelayed(action, delayMills);
        }
        ShadowApplication.getInstance().getForegroundThreadScheduler().postDelayed(action, delayMills);
        return true;
    }

    @Implementation
    protected void postInvalidateDelayed(long delayMilliseconds) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.PAUSED) {
            ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).postInvalidateDelayed(delayMilliseconds);
        } else {
            ShadowApplication.getInstance().getForegroundThreadScheduler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    ShadowView.this.realView.invalidate();
                }
            }, delayMilliseconds);
        }
    }

    @Implementation
    protected boolean removeCallbacks(Runnable callback) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.PAUSED) {
            return ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).removeCallbacks(callback);
        }
        ShadowLegacyLooper shadowLooper = (ShadowLegacyLooper)Shadow.extract((Object)Looper.getMainLooper());
        shadowLooper.getScheduler().remove(callback);
        return true;
    }

    @Implementation
    protected void scrollTo(int x, int y) {
        try {
            Method method = View.class.getDeclaredMethod("onScrollChanged", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.realView, x, y, this.scrollToCoordinates.x, this.scrollToCoordinates.y);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.scrollToCoordinates = new Point(x, y);
        ReflectionHelpers.setField((Object)this.realView, (String)"mScrollX", (Object)x);
        ReflectionHelpers.setField((Object)this.realView, (String)"mScrollY", (Object)y);
    }

    @Implementation
    protected void scrollBy(int x, int y) {
        this.scrollTo(this.getScrollX() + x, this.getScrollY() + y);
    }

    @Implementation
    protected int getScrollX() {
        return this.scrollToCoordinates != null ? this.scrollToCoordinates.x : 0;
    }

    @Implementation
    protected int getScrollY() {
        return this.scrollToCoordinates != null ? this.scrollToCoordinates.y : 0;
    }

    @Implementation
    protected void setScrollX(int scrollX) {
        this.scrollTo(scrollX, this.scrollToCoordinates.y);
    }

    @Implementation
    protected void setScrollY(int scrollY) {
        this.scrollTo(this.scrollToCoordinates.x, scrollY);
    }

    @Implementation
    protected int getLayerType() {
        return this.layerType;
    }

    @Implementation
    protected void setAnimation(Animation animation) {
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).setAnimation(animation);
        if (animation != null) {
            new AnimationRunner(animation);
        }
    }

    @Implementation
    protected void clearAnimation() {
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).clearAnimation();
        if (this.animationRunner != null) {
            this.animationRunner.cancel();
            this.animationRunner = null;
        }
    }

    @Implementation(minSdk=19)
    protected boolean isAttachedToWindow() {
        return this.getAttachInfo() != null;
    }

    private Object getAttachInfo() {
        return ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).getAttachInfo();
    }

    public void callOnAttachedToWindow() {
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).onAttachedToWindow();
    }

    public void callOnDetachedFromWindow() {
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).onDetachedFromWindow();
    }

    @Implementation(minSdk=18)
    protected WindowId getWindowId() {
        return WindowIdHelper.getWindowId(this);
    }

    @Implementation
    protected boolean performHapticFeedback(int hapticFeedbackType) {
        this.hapticFeedbackPerformed = hapticFeedbackType;
        return true;
    }

    @Implementation
    protected boolean getGlobalVisibleRect(Rect rect, Point globalOffset) {
        if (this.globalVisibleRect == null) {
            return ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).getGlobalVisibleRect(rect, globalOffset);
        }
        if (!this.globalVisibleRect.isEmpty()) {
            rect.set(this.globalVisibleRect);
            if (globalOffset != null) {
                rect.offset(-globalOffset.x, -globalOffset.y);
            }
            return true;
        }
        rect.setEmpty();
        return false;
    }

    public void setGlobalVisibleRect(Rect rect) {
        if (rect != null) {
            this.globalVisibleRect = new Rect();
            this.globalVisibleRect.set(rect);
        } else {
            this.globalVisibleRect = null;
        }
    }

    public int lastHapticFeedbackPerformed() {
        return this.hapticFeedbackPerformed;
    }

    public void setMyParent(ViewParent viewParent) {
        ((_View_)Reflector.reflector(_View_.class, (Object)this.realView)).assignParent(viewParent);
    }

    @Implementation
    protected void getWindowVisibleDisplayFrame(Rect outRect) {
        ShadowDisplay.getDefaultDisplay().getRectSize(outRect);
    }

    @Implementation(minSdk=24)
    protected void getWindowDisplayFrame(Rect outRect) {
        ShadowDisplay.getDefaultDisplay().getRectSize(outRect);
    }

    @ForType(className="android.view.View$AttachInfo")
    static interface _AttachInfo_ {
        @Accessor(value="mIWindowId")
        public void setIWindowId(IWindowId var1);

        @Accessor(value="mWindowId")
        public void setWindowId(WindowId var1);
    }

    public static class WindowIdHelper {
        public static WindowId getWindowId(ShadowView shadowView) {
            Object attachInfo;
            if (shadowView.isAttachedToWindow() && ReflectionHelpers.getField((Object)(attachInfo = shadowView.getAttachInfo()), (String)"mWindowId") == null) {
                MyIWindowIdStub iWindowId = new MyIWindowIdStub();
                ((_AttachInfo_)Reflector.reflector(_AttachInfo_.class, (Object)attachInfo)).setWindowId(new WindowId((IWindowId)iWindowId));
                ((_AttachInfo_)Reflector.reflector(_AttachInfo_.class, (Object)attachInfo)).setIWindowId((IWindowId)iWindowId);
            }
            return ((_View_)Reflector.reflector(_View_.class, (Object)shadowView.realView)).getWindowId();
        }

        private static class MyIWindowIdStub
        extends IWindowId.Stub {
            private MyIWindowIdStub() {
            }

            public void registerFocusObserver(IWindowFocusObserver iWindowFocusObserver) throws RemoteException {
            }

            public void unregisterFocusObserver(IWindowFocusObserver iWindowFocusObserver) throws RemoteException {
            }

            public boolean isFocused() throws RemoteException {
                return true;
            }
        }
    }

    @ForType(value=View.class)
    private static interface _View_ {
        @Direct
        public void onLayout(boolean var1, int var2, int var3, int var4, int var5);

        @Direct
        public void assignParent(ViewParent var1);

        @Direct
        public void setOnFocusChangeListener(View.OnFocusChangeListener var1);

        @Direct
        public void setOnClickListener(View.OnClickListener var1);

        @Direct
        public void setOnLongClickListener(View.OnLongClickListener var1);

        @Direct
        public void setOnSystemUiVisibilityChangeListener(View.OnSystemUiVisibilityChangeListener var1);

        @Direct
        public void setOnCreateContextMenuListener(View.OnCreateContextMenuListener var1);

        @Direct
        public void addOnAttachStateChangeListener(View.OnAttachStateChangeListener var1);

        @Direct
        public void removeOnAttachStateChangeListener(View.OnAttachStateChangeListener var1);

        @Direct
        public void requestLayout();

        @Direct
        public boolean performClick();

        @Direct
        public boolean performLongClick();

        @Direct
        public void invalidate();

        @Direct
        public boolean onTouchEvent(MotionEvent var1);

        @Direct
        public void setOnTouchListener(View.OnTouchListener var1);

        @Direct
        public boolean post(Runnable var1);

        @Direct
        public boolean postDelayed(Runnable var1, long var2);

        @Direct
        public void postInvalidateDelayed(long var1);

        @Direct
        public boolean removeCallbacks(Runnable var1);

        @Direct
        public void setAnimation(Animation var1);

        @Direct
        public void clearAnimation();

        @Direct
        public boolean getGlobalVisibleRect(Rect var1, Point var2);

        @Direct
        public WindowId getWindowId();

        @Accessor(value="mAttachInfo")
        public Object getAttachInfo();

        public void onAttachedToWindow();

        public void onDetachedFromWindow();
    }

    private class AnimationRunner
    implements Runnable {
        private final Animation animation;
        private long startTime;
        private long startOffset;
        private long elapsedTime;
        private boolean canceled;

        AnimationRunner(Animation animation) {
            this.animation = animation;
            this.start();
        }

        private void start() {
            this.startTime = this.animation.getStartTime();
            this.startOffset = this.animation.getStartOffset();
            Choreographer choreographer = Choreographer.getInstance();
            if (ShadowView.this.animationRunner != null) {
                choreographer.removeCallbacks(1, (Runnable)ShadowView.this.animationRunner, null);
            }
            ShadowView.this.animationRunner = this;
            int startDelay = this.startTime == -1L ? (int)this.startOffset : (int)(this.startTime + this.startOffset - SystemClock.uptimeMillis());
            choreographer.postCallbackDelayed(1, (Runnable)this, null, (long)startDelay);
        }

        @Override
        public void run() {
            if (!this.canceled && this.animation.getStartTime() == this.startTime && this.animation.getStartOffset() == this.startOffset && this.animation.getTransformation(this.startTime == -1L ? SystemClock.uptimeMillis() : this.startTime + this.startOffset + this.elapsedTime, new Transformation()) && (this.animation.getRepeatCount() != -1 || this.elapsedTime < this.animation.getDuration())) {
                this.startTime = this.animation.getStartTime();
                this.elapsedTime += ShadowChoreographer.getFrameInterval() / 1000000L;
                Choreographer.getInstance().postCallback(1, (Runnable)this, null);
            } else {
                ShadowView.this.animationRunner = null;
            }
        }

        public void cancel() {
            this.canceled = true;
        }
    }
}

