/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.animation.AnimationHandler;
import android.animation.ValueAnimator;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=ValueAnimator.class)
public class ShadowValueAnimator {
    @RealObject
    private ValueAnimator realObject;
    private int actualRepeatCount;

    @Resetter
    public static void reset() {
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            ThreadLocal animatorHandlerTL = (ThreadLocal)ReflectionHelpers.getStaticField(AnimationHandler.class, (String)"sAnimatorHandler");
            animatorHandlerTL.remove();
        } else {
            ReflectionHelpers.callStaticMethod(ValueAnimator.class, (String)"clearAllAnimations", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            ThreadLocal animatorHandlerTL = (ThreadLocal)ReflectionHelpers.getStaticField(ValueAnimator.class, (String)"sAnimationHandler");
            animatorHandlerTL.remove();
        }
        ShadowValueAnimator.setDurationScale(1.0f);
    }

    @Implementation
    protected void setRepeatCount(int count) {
        this.actualRepeatCount = count;
        if (count == -1) {
            count = 1;
        }
        ((ValueAnimatorReflector)Reflector.reflector(ValueAnimatorReflector.class, (Object)this.realObject)).setRepeatCount(count);
    }

    public int getActualRepeatCount() {
        return this.actualRepeatCount;
    }

    public static void setDurationScale(float duration) {
        ((ValueAnimatorReflector)Reflector.reflector(ValueAnimatorReflector.class, null)).setDurationScale(duration);
    }

    @ForType(value=ValueAnimator.class)
    static interface ValueAnimatorReflector {
        @Direct
        public void setRepeatCount(int var1);

        @Static
        @Accessor(value="sDurationScale")
        public void setDurationScale(float var1);
    }
}

