/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SystemApi;
import android.app.Application;
import android.app.UiModeManager;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=UiModeManager.class)
public class ShadowUIModeManager {
    public int currentModeType = 0;
    public int currentNightMode = 0;
    public int lastFlags;
    public int lastCarModePriority;
    private int currentApplicationNightMode = 0;
    private final Set<Integer> activeProjectionTypes = new HashSet<Integer>();
    private boolean failOnProjectionToggle;
    private static final ImmutableSet<Integer> VALID_NIGHT_MODES = ImmutableSet.of((Object)0, (Object)1, (Object)2);
    private static final int DEFAULT_PRIORITY = 0;

    @Implementation
    protected int getCurrentModeType() {
        return this.currentModeType;
    }

    @Implementation(maxSdk=29)
    protected void enableCarMode(int flags) {
        this.enableCarMode(0, flags);
    }

    @Implementation(minSdk=30)
    protected void enableCarMode(int priority, int flags) {
        this.currentModeType = 3;
        this.lastCarModePriority = priority;
        this.lastFlags = flags;
    }

    @Implementation
    protected void disableCarMode(int flags) {
        this.currentModeType = 1;
        this.lastFlags = flags;
    }

    @Implementation
    protected int getNightMode() {
        return this.currentNightMode;
    }

    @Implementation
    protected void setNightMode(int mode) {
        this.currentNightMode = VALID_NIGHT_MODES.contains((Object)mode) ? mode : 0;
    }

    public int getApplicationNightMode() {
        return this.currentApplicationNightMode;
    }

    public Set<Integer> getActiveProjectionTypes() {
        return new HashSet<Integer>(this.activeProjectionTypes);
    }

    public void setFailOnProjectionToggle(boolean failOnProjectionToggle) {
        this.failOnProjectionToggle = failOnProjectionToggle;
    }

    @Implementation(minSdk=31)
    @HiddenApi
    protected void setApplicationNightMode(int mode) {
        this.currentApplicationNightMode = mode;
    }

    @Implementation(minSdk=31)
    @SystemApi
    protected boolean requestProjection(int projectionType) {
        if (projectionType == 1) {
            this.assertHasPermission("android.permission.TOGGLE_AUTOMOTIVE_PROJECTION");
        }
        if (this.failOnProjectionToggle) {
            return false;
        }
        this.activeProjectionTypes.add(projectionType);
        return true;
    }

    @Implementation(minSdk=31)
    @SystemApi
    protected boolean releaseProjection(int projectionType) {
        if (projectionType == 1) {
            this.assertHasPermission("android.permission.TOGGLE_AUTOMOTIVE_PROJECTION");
        }
        if (this.failOnProjectionToggle) {
            return false;
        }
        return this.activeProjectionTypes.remove(projectionType);
    }

    private void assertHasPermission(String ... permissions) {
        Application context = RuntimeEnvironment.getApplication();
        for (String permission2 : permissions) {
            if (context.getPackageManager().checkPermission(permission2, context.getPackageName()) == 0) continue;
            String string2 = String.valueOf(permission2);
            throw new SecurityException(string2.length() != 0 ? "Missing required permission: ".concat(string2) : new String("Missing required permission: "));
        }
    }
}

