/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.MediaActionSound;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=MediaActionSound.class, minSdk=16)
public class ShadowMediaActionSound {
    @RealObject
    MediaActionSound realObject;
    private static final int[] ALL_SOUNDS = new int[]{0, 1, 2, 3};
    private static final int NUM_SOUNDS = ALL_SOUNDS.length;
    private static final Map<Integer, AtomicInteger> playCount = ShadowMediaActionSound.initializePlayCountMap();

    private static final HashMap<Integer, AtomicInteger> initializePlayCountMap() {
        HashMap<Integer, AtomicInteger> playCount = new HashMap<Integer, AtomicInteger>();
        for (int sound : ALL_SOUNDS) {
            playCount.put(sound, new AtomicInteger(0));
        }
        return playCount;
    }

    public static int getPlayCount(int soundName) {
        if (soundName < 0 || soundName >= NUM_SOUNDS) {
            throw new RuntimeException(new StringBuilder(31).append("Invalid sound name: ").append(soundName).toString());
        }
        return playCount.get(soundName).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        Map<Integer, AtomicInteger> map = playCount;
        synchronized (map) {
            for (AtomicInteger soundCount : playCount.values()) {
                soundCount.set(0);
            }
        }
    }

    @Implementation
    protected void play(int soundName) {
        ((MediaActionSoundReflector)Reflector.reflector(MediaActionSoundReflector.class, (Object)this.realObject)).play(soundName);
        playCount.get(soundName).incrementAndGet();
    }

    @ForType(value=MediaActionSound.class)
    static interface MediaActionSoundReflector {
        @Direct
        public void play(int var1);
    }
}

