/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.WithType;

@ThreadSafe
public interface VersionStore<VALUE, METADATA, VALUE_TYPE extends Enum<VALUE_TYPE>> {
    public Hash hashOnReference(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException;

    @Nonnull
    public Hash noAncestorHash();

    public WithHash<Ref> toRef(@Nonnull String var1) throws ReferenceNotFoundException;

    public Hash commit(@Nonnull BranchName var1, @Nonnull Optional<Hash> var2, @Nonnull METADATA var3, @Nonnull List<Operation<VALUE>> var4) throws ReferenceNotFoundException, ReferenceConflictException;

    public void transplant(BranchName var1, Optional<Hash> var2, List<Hash> var3) throws ReferenceNotFoundException, ReferenceConflictException;

    public void merge(Hash var1, BranchName var2, Optional<Hash> var3) throws ReferenceNotFoundException, ReferenceConflictException;

    public void assign(NamedRef var1, Optional<Hash> var2, Hash var3) throws ReferenceNotFoundException, ReferenceConflictException;

    public Hash create(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException, ReferenceAlreadyExistsException;

    public void delete(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException, ReferenceConflictException;

    public ReferenceInfo<METADATA> getNamedRef(String var1, GetNamedRefsParams var2) throws ReferenceNotFoundException;

    public Stream<ReferenceInfo<METADATA>> getNamedRefs(GetNamedRefsParams var1) throws ReferenceNotFoundException;

    public Stream<Commit<METADATA, VALUE>> getCommits(Ref var1, boolean var2) throws ReferenceNotFoundException;

    public Stream<WithType<Key, VALUE_TYPE>> getKeys(Ref var1) throws ReferenceNotFoundException;

    public VALUE getValue(Ref var1, Key var2) throws ReferenceNotFoundException;

    public Map<Key, VALUE> getValues(Ref var1, Collection<Key> var2) throws ReferenceNotFoundException;

    public Stream<Diff<VALUE>> getDiffs(Ref var1, Ref var2) throws ReferenceNotFoundException;
}

