/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.annotations.VisibleForTesting;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TracingUtil;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.WithType;

public class TracingVersionStore<VALUE, METADATA, VALUE_TYPE extends Enum<VALUE_TYPE>>
implements VersionStore<VALUE, METADATA, VALUE_TYPE> {
    private static final String TAG_OPERATION = "nessie.version-store.operation";
    private static final String TAG_REF = "nessie.version-store.ref";
    private static final String TAG_BRANCH = "nessie.version-store.branch";
    private static final String TAG_HASH = "nessie.version-store.hash";
    private static final String TAG_NUM_OPS = "nessie.version-store.num-ops";
    private static final String TAG_TARGET_BRANCH = "nessie.version-store.target-branch";
    private static final String TAG_TRANSPLANTS = "nessie.version-store.transplants";
    private static final String TAG_FROM_HASH = "nessie.version-store.from-hash";
    private static final String TAG_TO_BRANCH = "nessie.version-store.to-branch";
    private static final String TAG_EXPECTED_HASH = "nessie.version-store.expected-hash";
    private static final String TAG_TARGET_HASH = "nessie.version-store.target-hash";
    private static final String TAG_KEY = "nessie.version-store.key";
    private static final String TAG_KEYS = "nessie.version-store.keys";
    private static final String TAG_FROM = "nessie.version-store.from";
    private static final String TAG_TO = "nessie.version-store.to";
    private final VersionStore<VALUE, METADATA, VALUE_TYPE> delegate;

    public TracingVersionStore(VersionStore<VALUE, METADATA, VALUE_TYPE> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        return this.callWithOneException("HashOnReference", b -> b.withTag(TAG_REF, TracingVersionStore.safeRefName(namedReference)).withTag(TAG_HASH, TracingUtil.safeToString(hashOnReference)), () -> this.delegate.hashOnReference(namedReference, hashOnReference));
    }

    @Override
    @Nonnull
    public Hash noAncestorHash() {
        return this.delegate.noAncestorHash();
    }

    @Override
    public WithHash<Ref> toRef(@Nonnull String refOfUnknownType) throws ReferenceNotFoundException {
        return this.callWithOneException("ToRef", b -> b.withTag(TAG_REF, refOfUnknownType), () -> this.delegate.toRef(refOfUnknownType));
    }

    @Override
    public Hash commit(@Nonnull BranchName branch, @Nonnull Optional<Hash> referenceHash, @Nonnull METADATA metadata, @Nonnull List<Operation<VALUE>> operations) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.callWithTwoExceptions("Commit", (Tracer.SpanBuilder b) -> b.withTag(TAG_BRANCH, TracingVersionStore.safeRefName(branch)).withTag(TAG_HASH, TracingUtil.safeToString(referenceHash)).withTag(TAG_NUM_OPS, (Number)TracingUtil.safeSize(operations)), () -> this.delegate.commit(branch, referenceHash, metadata, operations));
    }

    @Override
    public void transplant(BranchName targetBranch, Optional<Hash> referenceHash, List<Hash> sequenceToTransplant) throws ReferenceNotFoundException, ReferenceConflictException {
        this.callWithTwoExceptions("Transplant", (Tracer.SpanBuilder b) -> b.withTag(TAG_TARGET_BRANCH, TracingVersionStore.safeRefName(targetBranch)).withTag(TAG_HASH, TracingUtil.safeToString(referenceHash)).withTag(TAG_TRANSPLANTS, (Number)TracingUtil.safeSize(sequenceToTransplant)), () -> this.delegate.transplant(targetBranch, referenceHash, sequenceToTransplant));
    }

    @Override
    public void merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.callWithTwoExceptions("Merge", (Tracer.SpanBuilder b) -> b.withTag(TAG_FROM_HASH, TracingUtil.safeToString(fromHash)).withTag(TAG_TO_BRANCH, TracingVersionStore.safeRefName(toBranch)).withTag(TAG_EXPECTED_HASH, TracingUtil.safeToString(expectedHash)), () -> this.delegate.merge(fromHash, toBranch, expectedHash));
    }

    @Override
    public void assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.callWithTwoExceptions("Assign", (Tracer.SpanBuilder b) -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)).withTag(TAG_EXPECTED_HASH, TracingUtil.safeToString(expectedHash)).withTag(TAG_TARGET_HASH, TracingUtil.safeToString(targetHash)), () -> this.delegate.assign(ref, expectedHash, targetHash));
    }

    @Override
    public Hash create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return this.callWithTwoExceptions("Create", (Tracer.SpanBuilder b) -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)).withTag(TAG_TARGET_HASH, TracingUtil.safeToString(targetHash)), () -> this.delegate.create(ref, targetHash));
    }

    @Override
    public void delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.callWithTwoExceptions("Delete", (Tracer.SpanBuilder b) -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)).withTag(TAG_HASH, TracingUtil.safeToString(hash)), () -> this.delegate.delete(ref, hash));
    }

    @Override
    public ReferenceInfo<METADATA> getNamedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        return this.callWithOneException("GetNamedRef", b -> b.withTag(TAG_REF, ref), () -> this.delegate.getNamedRef(ref, params));
    }

    @Override
    public Stream<ReferenceInfo<METADATA>> getNamedRefs(GetNamedRefsParams params) throws ReferenceNotFoundException {
        return this.callStreamWithOneException("GetNamedRefs", b -> {}, () -> this.delegate.getNamedRefs(params));
    }

    @Override
    public Stream<Commit<METADATA, VALUE>> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        return this.callStreamWithOneException("GetCommits", b -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)), () -> this.delegate.getCommits(ref, fetchAdditionalInfo));
    }

    @Override
    public Stream<WithType<Key, VALUE_TYPE>> getKeys(Ref ref) throws ReferenceNotFoundException {
        return this.callStreamWithOneException("GetKeys", b -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)), () -> this.delegate.getKeys(ref));
    }

    @Override
    public VALUE getValue(Ref ref, Key key) throws ReferenceNotFoundException {
        return (VALUE)this.callWithOneException("GetValue", b -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)).withTag(TAG_KEY, TracingUtil.safeToString(key)), () -> this.delegate.getValue(ref, key));
    }

    @Override
    public Map<Key, VALUE> getValues(Ref ref, Collection<Key> keys) throws ReferenceNotFoundException {
        return this.callWithOneException("GetValues", b -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)).withTag(TAG_KEYS, TracingUtil.safeToString(keys)), () -> this.delegate.getValues(ref, keys));
    }

    @Override
    public Stream<Diff<VALUE>> getDiffs(Ref from, Ref to) throws ReferenceNotFoundException {
        return this.callStreamWithOneException("GetDiffs", b -> b.withTag(TAG_FROM, TracingUtil.safeToString(from)).withTag(TAG_TO, TracingUtil.safeToString(to)), () -> this.delegate.getDiffs(from, to));
    }

    private Span createSpan(String name, Consumer<Tracer.SpanBuilder> spanBuilder) {
        Tracer tracer = GlobalTracer.get();
        String spanName = TracingVersionStore.makeSpanName(name);
        Tracer.SpanBuilder builder = tracer.buildSpan(spanName).asChildOf(tracer.activeSpan()).withTag(TAG_OPERATION, name);
        spanBuilder.accept(builder);
        return builder.start();
    }

    private Scope activeScope(Span span) {
        Tracer tracer = GlobalTracer.get();
        return tracer.activateSpan(span);
    }

    @VisibleForTesting
    static String makeSpanName(String name) {
        return "VersionStore." + Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private <R> Stream<R> callStream(String spanName, Consumer<Tracer.SpanBuilder> spanBuilder, Invoker<Stream<R>> invoker) {
        Span span = this.createSpan(spanName, spanBuilder);
        Scope scope = this.activeScope(span);
        Stream result = null;
        try {
            Stream stream = result = (Stream)invoker.handle().onClose(() -> ((Scope)scope).close());
            return stream;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw TracingUtil.traceError(span, e);
        }
        finally {
            if (result == null) {
                scope.close();
            }
        }
    }

    private <R, E1 extends VersionStoreException> Stream<R> callStreamWithOneException(String spanName, Consumer<Tracer.SpanBuilder> spanBuilder, InvokerWithOneException<Stream<R>, E1> invoker) throws E1 {
        Span span = this.createSpan(spanName, spanBuilder);
        Scope scope = this.activeScope(span);
        Stream result = null;
        try {
            Stream stream = result = (Stream)invoker.handle().onClose(() -> ((Scope)scope).close());
            return stream;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw TracingUtil.traceError(span, e);
        }
        finally {
            if (result == null) {
                scope.close();
            }
        }
    }

    private <R> R call(String spanName, Consumer<Tracer.SpanBuilder> spanBuilder, Invoker<R> invoker) {
        Span span = this.createSpan(spanName, spanBuilder);
        Scope scope = this.activeScope(span);
        try {
            R r = invoker.handle();
            return r;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw TracingUtil.traceError(span, e);
        }
        finally {
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private <R, E1 extends VersionStoreException> R callWithOneException(String spanName, Consumer<Tracer.SpanBuilder> spanBuilder, InvokerWithOneException<R, E1> invoker) throws E1 {
        Span span = this.createSpan(spanName, spanBuilder);
        Scope scope = this.activeScope(span);
        try {
            R r = invoker.handle();
            return r;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw TracingUtil.traceError(span, e);
        }
        finally {
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private <E1 extends VersionStoreException, E2 extends VersionStoreException> void callWithTwoExceptions(String spanName, Consumer<Tracer.SpanBuilder> spanBuilder, InvokerWithTwoExceptions<E1, E2> invoker) throws E1, E2 {
        Span span = this.createSpan(spanName, spanBuilder);
        try (Scope scope = this.activeScope(span);){
            try {
                invoker.handle();
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw TracingUtil.traceError(span, e);
            }
        }
    }

    private <R, E1 extends VersionStoreException, E2 extends VersionStoreException> R callWithTwoExceptions(String spanName, Consumer<Tracer.SpanBuilder> spanBuilder, InvokerWithTwoExceptionsR<R, E1, E2> invoker) throws E1, E2 {
        Span span = this.createSpan(spanName, spanBuilder);
        Scope scope = this.activeScope(span);
        try {
            R r = invoker.handle();
            return r;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw TracingUtil.traceError(span, e);
        }
        finally {
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private static String safeRefName(NamedRef ref) {
        return ref != null ? ref.getName() : "<null>";
    }

    @FunctionalInterface
    static interface InvokerWithTwoExceptionsR<R, E1 extends VersionStoreException, E2 extends VersionStoreException> {
        public R handle() throws E1, E2;
    }

    @FunctionalInterface
    static interface InvokerWithTwoExceptions<E1 extends VersionStoreException, E2 extends VersionStoreException> {
        public void handle() throws E1, E2;
    }

    @FunctionalInterface
    static interface InvokerWithOneException<R, E1 extends VersionStoreException> {
        public R handle() throws E1;
    }

    @FunctionalInterface
    static interface Invoker<R> {
        public R handle();
    }
}

