/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStoreException;

public class ReferenceNotFoundException
extends VersionStoreException {
    private static final long serialVersionUID = -4231207387427624751L;

    public ReferenceNotFoundException(String message) {
        super(message);
    }

    public ReferenceNotFoundException(String message, Throwable cause) {
        super(message, cause);
    }

    @Nonnull
    public static ReferenceNotFoundException forReference(@Nonnull Ref ref) {
        String message;
        Objects.requireNonNull(ref);
        if (ref instanceof BranchName) {
            message = String.format("Branch '%s' does not exist", ((BranchName)ref).getName());
        } else if (ref instanceof TagName) {
            message = String.format("Tag '%s' does not exist", ((TagName)ref).getName());
        } else if (ref instanceof Hash) {
            message = String.format("Hash '%s' does not exist", ((Hash)ref).asString());
        } else {
            return ReferenceNotFoundException.forReference(ref.toString());
        }
        return new ReferenceNotFoundException(message);
    }

    @Nonnull
    public static ReferenceNotFoundException forReference(@Nonnull String ref) {
        Objects.requireNonNull(ref);
        return new ReferenceNotFoundException(String.format("Ref '%s' does not exist", ref));
    }
}

