/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableCommitsAheadBehind;
import org.projectnessie.versioned.ImmutableReferenceInfo;
import org.projectnessie.versioned.NamedRef;

@Value.Immutable
public interface ReferenceInfo<METADATA> {
    public NamedRef getNamedRef();

    public Hash getHash();

    @Value.Default
    default public long getCommitSeq() {
        return 0L;
    }

    @Nullable
    public Hash getCommonAncestor();

    public ReferenceInfo<METADATA> withCommonAncestor(@Nullable Hash var1);

    @Nullable
    public CommitsAheadBehind getAheadBehind();

    public ReferenceInfo<METADATA> withAheadBehind(@Nullable CommitsAheadBehind var1);

    @Nullable
    public METADATA getHeadCommitMeta();

    public ReferenceInfo<METADATA> withHeadCommitMeta(@Nullable METADATA var1);

    default public <UPDATED_METADATA> ReferenceInfo<UPDATED_METADATA> withUpdatedCommitMeta(UPDATED_METADATA commitMeta) {
        ReferenceInfo updated = this;
        return updated.withHeadCommitMeta(commitMeta);
    }

    public static <METADATA> ImmutableReferenceInfo.Builder<METADATA> builder() {
        return ImmutableReferenceInfo.builder();
    }

    public static <METADATA> ReferenceInfo<METADATA> of(Hash hash, NamedRef namedRef) {
        return ReferenceInfo.builder().namedRef(namedRef).hash(hash).build();
    }

    @Value.Immutable
    public static interface CommitsAheadBehind {
        public int getBehind();

        public int getAhead();

        public static CommitsAheadBehind of(int ahead, int behind) {
            return ImmutableCommitsAheadBehind.builder().ahead(ahead).behind(behind).build();
        }
    }
}

