/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import java.text.Collator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.projectnessie.versioned.ImmutableKey;

@Value.Immutable
public abstract class Key
implements Comparable<Key> {
    private static final ThreadLocal<Collator> COLLATOR = new ThreadLocal<Collator>(){

        @Override
        protected Collator initialValue() {
            Collator c = Collator.getInstance(Locale.US);
            c.setStrength(0);
            return c;
        }
    };

    public abstract List<String> getElements();

    static ImmutableKey.Builder builder() {
        return ImmutableKey.builder();
    }

    @Override
    public final int compareTo(Key that) {
        Collator collator = COLLATOR.get();
        List<String> a = this.getElements();
        List<String> b = that.getElements();
        int max = Math.min(a.size(), b.size());
        for (int i = 0; i < max; ++i) {
            int cmp = collator.compare(a.get(i), b.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return a.size() - b.size();
    }

    public int hashCode() {
        Collator collator = COLLATOR.get();
        return this.getElements().stream().map(s -> collator.getCollationKey((String)s)).collect(Collectors.toList()).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Key)) {
            return false;
        }
        Key that = (Key)obj;
        List<String> thisElements = this.getElements();
        List<String> thatElements = that.getElements();
        return thisElements.size() == thatElements.size() && this.compareTo(that) == 0;
    }

    public static Key of(String ... elements) {
        return ImmutableKey.builder().addElements(elements).build();
    }

    public String toString() {
        return this.getElements().stream().collect(Collectors.joining("."));
    }
}

