/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.WithType;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WithType", generator="Immutables")
@Immutable
public final class ImmutableWithType<T, E extends Enum<E>>
implements WithType<T, E> {
    private final Enum<E> type;
    private final T value;

    private ImmutableWithType(Enum<E> type, T value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public Enum<E> getType() {
        return this.type;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public final ImmutableWithType<T, E> withType(Enum<E> value) {
        if (this.type == value) {
            return this;
        }
        Enum<E> newValue = Objects.requireNonNull(value, "type");
        return new ImmutableWithType<T, E>(newValue, this.value);
    }

    public final ImmutableWithType<T, E> withValue(T value) {
        if (this.value == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "value");
        return new ImmutableWithType<T, E>(this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWithType && this.equalTo((ImmutableWithType)another);
    }

    private boolean equalTo(ImmutableWithType<?, ?> another) {
        return this.type.equals(another.type) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WithType").omitNullValues().add("type", this.type).add("value", this.value).toString();
    }

    public static <T, E extends Enum<E>> ImmutableWithType<T, E> copyOf(WithType<T, E> instance) {
        if (instance instanceof ImmutableWithType) {
            return (ImmutableWithType)instance;
        }
        return ImmutableWithType.builder().from(instance).build();
    }

    public static <T, E extends Enum<E>> Builder<T, E> builder() {
        return new Builder();
    }

    @Generated(from="WithType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T, E extends Enum<E>> {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private Enum<E> type;
        @Nullable
        private T value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T, E> from(WithType<T, E> instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            this.value(instance.getValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T, E> type(Enum<E> type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T, E> value(T value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableWithType<T, E> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWithType(this.type, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build WithType, some of required attributes are not set " + attributes;
        }
    }
}

