/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Operation;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Commit", generator="Immutables")
@Immutable
public final class ImmutableCommit<METADATA, VALUE>
implements Commit<METADATA, VALUE> {
    private final Hash hash;
    private final METADATA commitMeta;
    @Nullable
    private final Hash parentHash;
    @Nullable
    private final ImmutableList<Operation<VALUE>> operations;

    private ImmutableCommit(Hash hash, METADATA commitMeta, @Nullable Hash parentHash, @Nullable ImmutableList<Operation<VALUE>> operations) {
        this.hash = hash;
        this.commitMeta = commitMeta;
        this.parentHash = parentHash;
        this.operations = operations;
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    @Override
    public METADATA getCommitMeta() {
        return this.commitMeta;
    }

    @Override
    @Nullable
    public Hash getParentHash() {
        return this.parentHash;
    }

    @Override
    @Nullable
    public ImmutableList<Operation<VALUE>> getOperations() {
        return this.operations;
    }

    public final ImmutableCommit<METADATA, VALUE> withHash(Hash value) {
        if (this.hash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableCommit<METADATA, VALUE>(newValue, this.commitMeta, this.parentHash, this.operations);
    }

    public final ImmutableCommit<METADATA, VALUE> withCommitMeta(METADATA value) {
        if (this.commitMeta == value) {
            return this;
        }
        METADATA newValue = Objects.requireNonNull(value, "commitMeta");
        return new ImmutableCommit<METADATA, VALUE>(this.hash, newValue, this.parentHash, this.operations);
    }

    public final ImmutableCommit<METADATA, VALUE> withParentHash(@Nullable Hash value) {
        if (this.parentHash == value) {
            return this;
        }
        return new ImmutableCommit<METADATA, VALUE>(this.hash, this.commitMeta, value, this.operations);
    }

    @SafeVarargs
    public final ImmutableCommit<METADATA, VALUE> withOperations(Operation<VALUE> ... elements) {
        if (elements == null) {
            return new ImmutableCommit<METADATA, VALUE>(this.hash, this.commitMeta, this.parentHash, null);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommit<METADATA, VALUE>(this.hash, this.commitMeta, this.parentHash, newValue);
    }

    public final ImmutableCommit<METADATA, VALUE> withOperations(@Nullable Iterable<? extends Operation<VALUE>> elements) {
        if (this.operations == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableCommit<METADATA, VALUE>(this.hash, this.commitMeta, this.parentHash, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommit && this.equalTo((ImmutableCommit)another);
    }

    private boolean equalTo(ImmutableCommit<?, ?> another) {
        return this.hash.equals(another.hash) && this.commitMeta.equals(another.commitMeta) && Objects.equals(this.parentHash, another.parentHash) && Objects.equals(this.operations, another.operations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.commitMeta.hashCode();
        h += (h << 5) + Objects.hashCode(this.parentHash);
        h += (h << 5) + Objects.hashCode(this.operations);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Commit").omitNullValues().add("hash", (Object)this.hash).add("commitMeta", this.commitMeta).add("parentHash", (Object)this.parentHash).add("operations", this.operations).toString();
    }

    public static <METADATA, VALUE> ImmutableCommit<METADATA, VALUE> copyOf(Commit<METADATA, VALUE> instance) {
        if (instance instanceof ImmutableCommit) {
            return (ImmutableCommit)instance;
        }
        return ImmutableCommit.builder().from(instance).build();
    }

    public static <METADATA, VALUE> Builder<METADATA, VALUE> builder() {
        return new Builder();
    }

    @Generated(from="Commit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<METADATA, VALUE> {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_COMMIT_META = 2L;
        private long initBits = 3L;
        @Nullable
        private Hash hash;
        @Nullable
        private METADATA commitMeta;
        @Nullable
        private Hash parentHash;
        private ImmutableList.Builder<Operation<VALUE>> operations = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA, VALUE> from(Commit<METADATA, VALUE> instance) {
            List<Operation<VALUE>> operationsValue;
            Objects.requireNonNull(instance, "instance");
            this.hash(instance.getHash());
            this.commitMeta(instance.getCommitMeta());
            Hash parentHashValue = instance.getParentHash();
            if (parentHashValue != null) {
                this.parentHash(parentHashValue);
            }
            if ((operationsValue = instance.getOperations()) != null) {
                this.addAllOperations(operationsValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA, VALUE> hash(Hash hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA, VALUE> commitMeta(METADATA commitMeta) {
            this.commitMeta = Objects.requireNonNull(commitMeta, "commitMeta");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA, VALUE> parentHash(@Nullable Hash parentHash) {
            this.parentHash = parentHash;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA, VALUE> addOperations(Operation<VALUE> element) {
            if (this.operations == null) {
                this.operations = ImmutableList.builder();
            }
            this.operations.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder<METADATA, VALUE> addOperations(Operation<VALUE> ... elements) {
            if (this.operations == null) {
                this.operations = ImmutableList.builder();
            }
            this.operations.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA, VALUE> operations(@Nullable Iterable<? extends Operation<VALUE>> elements) {
            if (elements == null) {
                this.operations = null;
                return this;
            }
            this.operations = ImmutableList.builder();
            return this.addAllOperations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA, VALUE> addAllOperations(Iterable<? extends Operation<VALUE>> elements) {
            Objects.requireNonNull(elements, "operations element");
            if (this.operations == null) {
                this.operations = ImmutableList.builder();
            }
            this.operations.addAll(elements);
            return this;
        }

        public ImmutableCommit<METADATA, VALUE> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommit(this.hash, this.commitMeta, this.parentHash, this.operations == null ? null : this.operations.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commitMeta");
            }
            return "Cannot build Commit, some of required attributes are not set " + attributes;
        }
    }
}

