/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.mongodb;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.Defaults;
import de.flapdoodle.embed.mongo.config.ImmutableMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.MongodProcessOutputConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.io.StreamProcessor;
import de.flapdoodle.embed.process.runtime.Network;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.projectnessie.versioned.persist.mongodb.MongoTestConnectionProviderSource;

public class FlapdoodleMongoTestConnectionProviderSource
extends MongoTestConnectionProviderSource {
    private static final Pattern LISTEN_ON_PORT_PATTERN = Pattern.compile(".*NETWORK([^\\n]*).*Waiting for connections.*\"port\":([0-9]+).*", 40);
    private final AtomicInteger port = new AtomicInteger();
    private MongodExecutable mongo;

    public void start() throws Exception {
        if (this.mongo != null) {
            throw new IllegalStateException("Already started");
        }
        final ProcessOutput defaultOutput = MongodProcessOutputConfig.getDefaultInstance((Command)Command.MongoD);
        StreamProcessor capturedStdout = new StreamProcessor(){
            private final StringBuilder buffer = new StringBuilder();

            public void process(String block) {
                if (FlapdoodleMongoTestConnectionProviderSource.this.port.get() == 0) {
                    this.buffer.append(block);
                    Matcher matcher = LISTEN_ON_PORT_PATTERN.matcher(this.buffer);
                    if (matcher.matches()) {
                        String portString = matcher.group(2);
                        FlapdoodleMongoTestConnectionProviderSource.this.port.set(Integer.parseInt(portString));
                    }
                }
                defaultOutput.output().process(block);
            }

            public void onProcessed() {
                defaultOutput.output().onProcessed();
            }
        };
        MongodStarter starter = MongodStarter.getInstance((RuntimeConfig)Defaults.runtimeConfigFor((Command)Command.MongoD).processOutput((ProcessOutput)ProcessOutput.builder().output(capturedStdout).error(defaultOutput.error()).commands(defaultOutput.commands()).build()).build());
        ImmutableMongodConfig mongodConfig = MongodConfig.builder().version((IFeatureAwareVersion)Version.Main.PRODUCTION).net(new Net(0, Network.localhostIsIPv6())).build();
        this.mongo = (MongodExecutable)starter.prepare((ExecutableProcessConfig)mongodConfig);
        this.mongo.start();
        Assertions.assertThat((AtomicInteger)this.port).hasPositiveValue();
        String connectionString = String.format("mongodb://localhost:%d", this.port.get());
        String databaseName = "test";
        this.configureConnectionProviderConfigFromDefaults(c -> c.withConnectionString(connectionString).withDatabaseName(databaseName));
        super.start();
    }

    public void stop() throws Exception {
        try {
            super.stop();
        }
        finally {
            try {
                if (this.mongo != null) {
                    this.mongo.stop();
                }
            }
            finally {
                this.mongo = null;
            }
        }
    }
}

