/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.inmem;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyWithType;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.inmem.InmemoryStore;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapter;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalOperationContext;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;
import org.projectnessie.versioned.persist.serialize.ProtoSerialization;

public class InmemoryDatabaseAdapter
extends NonTransactionalDatabaseAdapter<NonTransactionalDatabaseAdapterConfig> {
    private final InmemoryStore store;
    private final ByteString keyPrefix;

    public InmemoryDatabaseAdapter(NonTransactionalDatabaseAdapterConfig config, InmemoryStore store) {
        super(config);
        this.keyPrefix = ByteString.copyFromUtf8((String)(config.getRepositoryId() + ':'));
        Objects.requireNonNull(store, "Requires a non-null InmemoryStore from InmemoryDatabaseAdapterConfig");
        this.store = store;
    }

    private ByteString dbKey(Hash hash) {
        return this.keyPrefix.concat(hash.asBytes());
    }

    private ByteString dbKey(ByteString key) {
        return this.keyPrefix.concat(key);
    }

    public void eraseRepo() {
        this.store.reinitializeRepo(this.keyPrefix);
    }

    protected AdapterTypes.GlobalStatePointer fetchGlobalPointer(NonTransactionalOperationContext ctx) {
        return this.globalState().get();
    }

    protected void writeIndividualCommit(NonTransactionalOperationContext ctx, CommitLogEntry entry) throws ReferenceConflictException {
        if (this.store.commitLog.putIfAbsent(this.dbKey(entry.getHash()), ProtoSerialization.toProto((CommitLogEntry)entry).toByteString()) != null) {
            throw DatabaseAdapterUtil.hashCollisionDetected();
        }
    }

    protected void writeMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) throws ReferenceConflictException {
        for (CommitLogEntry entry : entries) {
            this.writeIndividualCommit(ctx, entry);
        }
    }

    protected void writeGlobalCommit(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStateLogEntry entry) throws ReferenceConflictException {
        if (this.store.globalStateLog.putIfAbsent(this.dbKey(entry.getId()), entry.toByteString()) != null) {
            throw DatabaseAdapterUtil.hashCollisionDetected();
        }
    }

    protected void unsafeWriteGlobalPointer(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer pointer) {
        this.globalState().set(pointer);
    }

    protected boolean globalPointerCas(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer expected, AdapterTypes.GlobalStatePointer newPointer) {
        return this.globalState().compareAndSet(expected, newPointer);
    }

    private AtomicReference<AdapterTypes.GlobalStatePointer> globalState() {
        return this.store.globalStatePointer.computeIfAbsent(this.keyPrefix, k -> new AtomicReference());
    }

    protected void cleanUpCommitCas(NonTransactionalOperationContext ctx, Hash globalId, Set<Hash> branchCommits, Set<Hash> newKeyLists) {
        this.store.globalStateLog.remove(this.dbKey(globalId));
        branchCommits.forEach(h -> this.store.commitLog.remove(this.dbKey((Hash)h)));
        newKeyLists.forEach(h -> this.store.keyLists.remove(this.dbKey((Hash)h)));
    }

    protected AdapterTypes.GlobalStateLogEntry fetchFromGlobalLog(NonTransactionalOperationContext ctx, Hash id) {
        ByteString serialized = (ByteString)this.store.globalStateLog.get(this.dbKey(id));
        try {
            return serialized != null ? AdapterTypes.GlobalStateLogEntry.parseFrom((ByteString)serialized) : null;
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<AdapterTypes.GlobalStateLogEntry> fetchPageFromGlobalLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return hashes.stream().map(this::dbKey).map(this.store.globalStateLog::get).map(serialized -> {
            try {
                return serialized != null ? AdapterTypes.GlobalStateLogEntry.parseFrom((ByteString)serialized) : null;
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    protected CommitLogEntry fetchFromCommitLog(NonTransactionalOperationContext ctx, Hash hash) {
        return ProtoSerialization.protoToCommitLogEntry((ByteString)((ByteString)this.store.commitLog.get(this.dbKey(hash))));
    }

    protected List<CommitLogEntry> fetchPageFromCommitLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return hashes.stream().map(this::dbKey).map(this.store.commitLog::get).map(ProtoSerialization::protoToCommitLogEntry).collect(Collectors.toList());
    }

    protected void writeKeyListEntities(NonTransactionalOperationContext ctx, List<KeyListEntity> newKeyListEntities) {
        newKeyListEntities.forEach(e -> this.store.keyLists.put(this.dbKey(e.getId()), ProtoSerialization.toProto((KeyList)e.getKeys()).toByteString()));
    }

    protected Stream<KeyListEntity> fetchKeyLists(NonTransactionalOperationContext ctx, List<Hash> keyListsIds) {
        return keyListsIds.stream().map(hash -> {
            ByteString serialized = (ByteString)this.store.keyLists.get(this.dbKey((Hash)hash));
            return serialized != null ? KeyListEntity.of((Hash)hash, (KeyList)ProtoSerialization.protoToKeyList((ByteString)serialized)) : null;
        }).filter(Objects::nonNull);
    }

    protected int entitySize(CommitLogEntry entry) {
        return ProtoSerialization.toProto((CommitLogEntry)entry).getSerializedSize();
    }

    protected int entitySize(KeyWithType entry) {
        return ProtoSerialization.toProto((KeyWithType)entry).getSerializedSize();
    }
}

