/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.SqlView;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SqlView", generator="Immutables")
@Immutable
public final class ImmutableSqlView
extends SqlView {
    private final String id;
    private final String sqlText;
    private final SqlView.Dialect dialect;

    private ImmutableSqlView(Builder builder) {
        this.sqlText = builder.sqlText;
        this.dialect = builder.dialect;
        this.id = builder.id != null ? builder.id : Objects.requireNonNull(super.getId(), "id");
    }

    private ImmutableSqlView(String id, String sqlText, SqlView.Dialect dialect) {
        this.id = id;
        this.sqlText = sqlText;
        this.dialect = dialect;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="sqlText")
    public String getSqlText() {
        return this.sqlText;
    }

    @Override
    @JsonProperty(value="dialect")
    public SqlView.Dialect getDialect() {
        return this.dialect;
    }

    public final ImmutableSqlView withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlView(newValue, this.sqlText, this.dialect);
    }

    public final ImmutableSqlView withSqlText(String value) {
        String newValue = Objects.requireNonNull(value, "sqlText");
        if (this.sqlText.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlView(this.id, newValue, this.dialect);
    }

    public final ImmutableSqlView withDialect(SqlView.Dialect value) {
        if (this.dialect == value) {
            return this;
        }
        SqlView.Dialect newValue = Objects.requireNonNull(value, "dialect");
        if (this.dialect.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSqlView(this.id, this.sqlText, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSqlView && this.equalTo((ImmutableSqlView)another);
    }

    private boolean equalTo(ImmutableSqlView another) {
        return this.id.equals(another.id) && this.sqlText.equals(another.sqlText) && this.dialect.equals((Object)another.dialect);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.sqlText.hashCode();
        h += (h << 5) + this.dialect.hashCode();
        return h;
    }

    public String toString() {
        return "SqlView{id=" + this.id + ", sqlText=" + this.sqlText + ", dialect=" + (Object)((Object)this.dialect) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSqlView fromJson(Json json) {
        Builder builder = ImmutableSqlView.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.sqlText != null) {
            builder.sqlText(json.sqlText);
        }
        if (json.dialect != null) {
            builder.dialect(json.dialect);
        }
        return builder.build();
    }

    public static ImmutableSqlView copyOf(SqlView instance) {
        if (instance instanceof ImmutableSqlView) {
            return (ImmutableSqlView)instance;
        }
        return ImmutableSqlView.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SqlView", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SQL_TEXT = 1L;
        private static final long INIT_BIT_DIALECT = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String sqlText;
        @Nullable
        private SqlView.Dialect dialect;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SqlView instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Content instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Content instance;
            if (object instanceof SqlView) {
                instance = (SqlView)object;
                this.sqlText(((SqlView)instance).getSqlText());
                this.dialect(((SqlView)instance).getDialect());
            }
            if (object instanceof Content) {
                instance = (Content)object;
                this.id(instance.getId());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="sqlText")
        @CanIgnoreReturnValue
        public final Builder sqlText(String sqlText) {
            this.sqlText = Objects.requireNonNull(sqlText, "sqlText");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="dialect")
        @CanIgnoreReturnValue
        public final Builder dialect(SqlView.Dialect dialect) {
            this.dialect = Objects.requireNonNull(dialect, "dialect");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSqlView build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSqlView(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sqlText");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dialect");
            }
            return "Cannot build SqlView, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SqlView", generator="Immutables")
    static final class Json
    extends SqlView {
        @Nullable
        String id;
        @Nullable
        String sqlText;
        @Nullable
        SqlView.Dialect dialect;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="sqlText")
        public void setSqlText(String sqlText) {
            this.sqlText = sqlText;
        }

        @JsonProperty(value="dialect")
        public void setDialect(SqlView.Dialect dialect) {
            this.dialect = dialect;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSqlText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SqlView.Dialect getDialect() {
            throw new UnsupportedOperationException();
        }
    }
}

